/*
 *  file generic_decorator.cc
 *
 *  Copyright (C) 1999 EPITA-LRDE
 *  EPITA Research and Development Laboratory
 */

#include <iostream>



// --------------------------  ConcreteComponent



class ConcreteComponent
{
public:
  void Operation()
    {
      std::cout << "ConcreteComponent::Operation" << std::endl;
    }
};



// --------------------------  ConcreteDecoratorA<C>



template< class C >
class ConcreteDecoratorA : public C
{
public:
  void Operation()
    {
      C::Operation();
      addedState = 1;
    }
protected:
  int addedState;
};



// --------------------------  ConcreteDecoratorB<C>



template< class C >
class ConcreteDecoratorB : public C
{
public:
  void Operation()
    {
      C::Operation();
      AddedBehaviour();
    }
protected:
  void AddedBehaviour()
    {
      std::cout << "ConcreteDecoratorB::AddedBehaviour" << std::endl;
    }
};



// --------------------------  main



int main()
{
  ConcreteDecoratorB< ConcreteComponent >  cb;
  cb.Operation();
}
