/*
 *  file generic_template_method.cc
 *
 *  Copyright (C) 1999 EPITA-LRDE
 *  EPITA Research and Development Laboratory
 */

#include <iostream>



// --------------------------  SuperiorOf<I>



template< class I >
class SuperiorOf 
{  
protected:
  SuperiorOf()
    {
    }
  I& Self()
    {
      return static_cast<I&>(*this); 
    }
};



// --------------------------  AbstractClass<I>



template< class I >
class AbstractClass : public SuperiorOf<I>
{
public:
  void TemplateMethod()
    {
      // ...
      PrimitiveOperation1();
      // ...
      PrimitiveOperation2();
      // ...
    }
  void PrimitiveOperation1()
    {
      Self().PrimitiveOperation1_impl();
    }
  void PrimitiveOperation2()
    {
      Self().PrimitiveOperation2_impl();
    }
};



// --------------------------  ConcreteClass



class ConcreteClass : public AbstractClass< ConcreteClass >
{
public:
  void PrimitiveOperation1_impl()
    {
      std::cout << "ConcreteClass::PrimitiveOperation1" << std::endl;
    }
  void PrimitiveOperation2_impl()
    {
      std::cout << "ConcreteClass::PrimitiveOperation2" << std::endl;
    }
};



// --------------------------  main



int main()
{
  ConcreteClass obj;
  obj.TemplateMethod();
}
