template < class T, class Closure >
struct matrix33_closure 
{

  matrix33_closure(Closure c) : mat(c) {};

  T get_val (int row, int col) const {
    return mat.get_val (row, col);
  }

  Closure mat;
};


template< class T, class ClosureL, class ClosureR >
struct matrix33_sum {

  matrix33_sum (const matrix33_closure<T,ClosureL> & l,
		const matrix33_closure<T,ClosureR> & r) : l(l), r(r) {};

  T get_val (int row, int col) const {
    return l.get_val (row, col) + r.get_val (row, col);
  }

  const matrix33_closure<T,ClosureL> l;
  const matrix33_closure<T,ClosureR> r;
};

// etc ... (define this for each operation!)

// ----------------------------------------

template< class T >
class matrix33 {
public:

  template< class U >
  matrix33& operator= (const matrix33_closure<T,U>& r) {
    for (int i = 0; i<3; ++i)
      for (int j = 0; j<3; ++j)
	set_val (r.get_val (i, j), i, j);
    return *this;
  }

  T get_val (int row, int col) const {
    return data[row][col];
  }

  void set_val (T val, int row, int col) {
    data[row][col] = val;
  }

private:
  T data[3][3];
};

// ----------------------------------------

template< class T, class ClosureL, class ClosureR >
matrix33_closure< T, matrix33_sum<T, ClosureL, ClosureR> >
operator+ (const matrix33_closure<T,ClosureL> & l,
	   const matrix33_closure<T,ClosureR> & r) {
  typedef matrix33_sum<T,ClosureL,ClosureR> Closure;
  return matrix33_closure< T, Closure > (Closure (l, r));
}

template< class T, class ClosureR >
matrix33_closure< T, matrix33_sum< T, matrix33_closure< T, const matrix33<T>& >,
                                      ClosureR > >
operator+ (const matrix33<T> & l,
	   const matrix33_closure<T,ClosureR> & r) {
  typedef matrix33_closure< T,const matrix33<T>& > ClosureL;
  typedef matrix33_sum<T, ClosureL, ClosureR> Closure;
  return matrix33_closure< T, Closure > (Closure (ClosureL (l), r));
}

template< class T, class ClosureL >
matrix33_closure< T, matrix33_sum< T, ClosureL,
                                      matrix33_closure< T, const matrix33<T>& > > >
operator+ (const matrix33_closure<T,ClosureL> & l,
	   const matrix33<T> & r) {
  typedef matrix33_closure< T,const matrix33<T>& > ClosureR;
  typedef matrix33_sum<T, ClosureL, ClosureR > Closure;
  return matrix33_closure< T, Closure > (Closure (l, ClosureR (r)));
}

template< class T >
matrix33_closure< T, matrix33_sum< T, matrix33_closure< T,const matrix33<T>& >,
                                      matrix33_closure< T,const matrix33<T>& > > >
operator+ (const matrix33<T> & l,
	   const matrix33<T> & r) {
  typedef matrix33_closure< T,const matrix33<T>& > ClosureLR;
  typedef matrix33_sum<T, ClosureLR, ClosureLR > Closure;
  return matrix33_closure< T, Closure > (Closure (ClosureLR (l),
						  ClosureLR (r)));
}

// etc... (define this for each operator!)
