/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.tools.ant;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Path;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginFragment;
import org.java.plugin.registry.PluginPrerequisite;
import org.java.plugin.registry.UniqueIdentity;
import org.java.plugin.tools.ant.BaseJpfTask;
import org.java.plugin.util.IoUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortTask
extends BaseJpfTask {
    public static final String MODE_DIR = "DIR";
    public static final String MODE_BUILD = "BUILD";
    public static final String MODE_MANIFEST = "MANIFEST";
    private String pathId;
    private String pathIdRef;
    private String pathMode = "MANIFEST";
    private boolean reverse;

    public void setPathId(String value) {
        this.pathId = value;
    }

    public void setPathIdRef(String value) {
        this.pathIdRef = value;
    }

    public void setPathMode(String value) {
        this.pathMode = value;
    }

    public void setReverse(boolean value) {
        this.reverse = value;
    }

    public void execute() throws BuildException {
        Path path;
        if (this.pathId == null && this.pathIdRef == null) {
            throw new BuildException("pathid or pathidref attribute must be set!", this.getLocation());
        }
        this.initRegistry(true);
        ArrayList<PluginDescriptor> descriptors = new ArrayList<PluginDescriptor>(this.getRegistry().getPluginDescriptors());
        this.reorder(descriptors);
        Collection<PluginFragment> fragments = this.getRegistry().getPluginFragments();
        ArrayList<UniqueIdentity> manifests = new ArrayList<UniqueIdentity>(descriptors.size() + fragments.size());
        manifests.addAll(descriptors);
        for (PluginFragment fragment : fragments) {
            int p = manifests.indexOf(this.getRegistry().getPluginDescriptor(fragment.getPluginId()));
            if (p == -1) {
                p = manifests.size() - 1;
            }
            manifests.add(p + 1, fragment);
        }
        if (this.reverse) {
            Collections.reverse(manifests);
        }
        if (this.pathIdRef != null) {
            Object ref = this.getProject().getReference(this.pathIdRef);
            if (!(ref instanceof Path)) {
                throw new BuildException("invalid reference " + this.pathIdRef + ", expected " + Path.class.getName() + ", found " + ref, this.getLocation());
            }
            path = (Path)ref;
        } else {
            path = new Path(this.getProject());
            this.getProject().addReference(this.pathId, (Object)path);
        }
        int count = 0;
        for (UniqueIdentity idt : manifests) {
            URL url = idt instanceof PluginFragment ? ((PluginFragment)idt).getLocation() : ((PluginDescriptor)idt).getLocation();
            File file = this.getResultFile(url);
            if (file == null) continue;
            path.setLocation(file);
            ++count;
            if (!this.getVerbose()) continue;
            this.log("Collected file " + file + " for manifest " + url + " (" + idt + ")");
        }
        if (this.getVerbose()) {
            this.log("Collected path entries: " + count);
        }
    }

    protected File getResultFile(URL manifestUrl) {
        File manifestFile = IoUtil.url2file(manifestUrl);
        if (manifestFile == null) {
            this.log("Ignoring non-local URL " + manifestUrl);
            return null;
        }
        if (MODE_MANIFEST.equalsIgnoreCase(this.pathMode)) {
            return manifestFile;
        }
        if (MODE_DIR.equalsIgnoreCase(this.pathMode)) {
            return manifestFile.getParentFile();
        }
        if (MODE_BUILD.equalsIgnoreCase(this.pathMode)) {
            return new File(manifestFile.getParentFile(), "build.xml");
        }
        return manifestFile;
    }

    protected void reorder(List<PluginDescriptor> descriptors) {
        block0: for (int i = 0; i < descriptors.size(); ++i) {
            for (int j = i + 1; j < descriptors.size(); ++j) {
                if (!this.isDepends(descriptors.get(i), descriptors.get(j))) continue;
                Collections.swap(descriptors, i, j);
                i = -1;
                continue block0;
            }
        }
    }

    private boolean isDepends(PluginDescriptor descr1, PluginDescriptor descr2) {
        HashSet<PluginDescriptor> pre1 = new HashSet<PluginDescriptor>();
        HashSet<PluginDescriptor> pre2 = new HashSet<PluginDescriptor>();
        this.collectPrerequisites(descr1, pre1);
        this.collectPrerequisites(descr2, pre2);
        return pre1.contains(descr2) && !pre2.contains(descr1);
    }

    private void collectPrerequisites(PluginDescriptor descr, Set<PluginDescriptor> result) {
        for (PluginPrerequisite pre : descr.getPrerequisites()) {
            PluginDescriptor descriptor;
            if (!pre.matches() || !result.add(descriptor = this.getRegistry().getPluginDescriptor(pre.getPluginId()))) continue;
            this.collectPrerequisites(descriptor, result);
        }
    }
}

