/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.tools.ant;

import org.apache.tools.ant.BuildException;
import org.java.plugin.registry.IntegrityCheckReport;
import org.java.plugin.tools.ant.BaseJpfTask;

public final class CheckTask
extends BaseJpfTask {
    private boolean usePathResolver;

    public void setUsePathResolver(boolean aUsePathResolver) {
        this.usePathResolver = aUsePathResolver;
    }

    public void execute() {
        this.initRegistry(this.usePathResolver);
        IntegrityCheckReport report = this.getRegistry().checkIntegrity(this.getPathResolver());
        if (this.getVerbose()) {
            this.log(CheckTask.integrityCheckReport2str(report));
        }
        this.log("Integrity check done. Errors: " + report.countErrors() + ". Warnings: " + report.countWarnings() + ".");
        if (report.countErrors() > 0) {
            throw new BuildException("plug-ins set integrity check failed, errors count - " + report.countErrors());
        }
    }

    private static String integrityCheckReport2str(IntegrityCheckReport report) {
        StringBuilder buf = new StringBuilder();
        buf.append("Integrity check report:\r\n");
        buf.append("-------------- REPORT BEGIN -----------------\r\n");
        for (IntegrityCheckReport.ReportItem item : report.getItems()) {
            buf.append("severity=").append((Object)item.getSeverity()).append("; code=").append((Object)item.getCode()).append("; message=").append(item.getMessage()).append("; source=").append(item.getSource()).append("\r\n");
        }
        buf.append("-------------- REPORT END -----------------");
        return buf.toString();
    }
}

