/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.bitset;

import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.BitSet;
import java.util.NoSuchElementException;

class BitSetComplementIterator
implements IntIterator {
    private final BitSet bitSet;
    private final int length;
    private int current = -1;
    private int next;

    BitSetComplementIterator(BitSet bitSet, int length) {
        this.bitSet = bitSet;
        this.length = length;
        this.next = this.getNext(0);
    }

    private int getNext(int index) {
        int next = this.bitSet.nextClearBit(index);
        return next < this.length ? next : -1;
    }

    public boolean hasNext() {
        return this.next != -1;
    }

    public int nextInt() {
        if (this.next == -1) {
            throw new NoSuchElementException();
        }
        this.current = this.next;
        this.next = this.getNext(this.next + 1);
        return this.current;
    }

    public void remove() {
        if (this.current == -1) {
            throw new IllegalStateException();
        }
        assert (!this.bitSet.get(this.current));
        this.bitSet.set(this.current);
    }
}

