/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.set;

import de.tum.in.naturals.set.NatCartesianProductIterator;
import it.unimi.dsi.fastutil.Size64;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.function.Predicate;

public class NatCartesianProductSet
extends AbstractSet<int[]>
implements Size64 {
    private final int[] domainMaximalElements;
    private final long size;

    public NatCartesianProductSet(int[] domainMaximalElements) {
        for (int domainSize : this.domainMaximalElements = (int[])domainMaximalElements.clone()) {
            if (domainSize >= 0) continue;
            throw new IllegalArgumentException("Domain maximum must be non-negative");
        }
        this.size = NatCartesianProductSet.numberOfElements(this.domainMaximalElements);
    }

    public static long numberOfElements(int[] domainMaximalElements) {
        long count = 1L;
        for (int maximalElement : domainMaximalElements) {
            assert (maximalElement >= 0);
            count *= (long)maximalElement + 1L;
        }
        return count;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof int[])) {
            return false;
        }
        int[] array = (int[])o;
        if (array.length != this.domainMaximalElements.length) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            int val = array[i];
            if (0 >= val && this.domainMaximalElements[i] >= val) continue;
            return false;
        }
        return true;
    }

    public NatCartesianProductIterator iterator() {
        return new NatCartesianProductIterator(this.domainMaximalElements, this.size);
    }

    @Override
    public int size() {
        return (int)Math.min(this.size, Integer.MAX_VALUE);
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeIf(Predicate<? super int[]> filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public long size64() {
        return this.size;
    }
}

