/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.edge;

import de.tum.in.naturals.NaturalsTransformer;
import de.tum.in.naturals.bitset.BitSets;
import de.tum.in.naturals.bitset.ImmutableBitSet;
import java.util.BitSet;
import java.util.PrimitiveIterator;
import java.util.function.IntUnaryOperator;
import javax.annotation.Nonnegative;
import owl.automaton.edge.EdgeGeneric;
import owl.automaton.edge.EdgeLong;
import owl.automaton.edge.EdgeSingleton;

public interface Edge<S> {
    public static <S> Edge<S> of(S successor) {
        return new EdgeSingleton<S>(successor);
    }

    public static <S> Edge<S> of(S successor, @Nonnegative int acceptance) {
        return new EdgeSingleton<S>(successor, acceptance);
    }

    public static <S> Edge<S> of(S successor, BitSet acceptance) {
        if (acceptance.isEmpty()) {
            return Edge.of(successor);
        }
        if (acceptance.cardinality() == 1) {
            return Edge.of(successor, acceptance.nextSetBit(0));
        }
        if (acceptance.length() <= 64) {
            return new EdgeLong<S>(successor, acceptance);
        }
        return new EdgeGeneric<S>(successor, (BitSet)ImmutableBitSet.copyOf((BitSet)acceptance));
    }

    public PrimitiveIterator.OfInt acceptanceSetIterator();

    public S successor();

    public boolean hasAcceptanceSets();

    public boolean inSet(@Nonnegative int var1);

    public int largestAcceptanceSet();

    public int smallestAcceptanceSet();

    default public Edge<S> withAcceptance(int i) {
        return Edge.of(this.successor(), i);
    }

    default public Edge<S> withAcceptance(BitSet acceptance) {
        return Edge.of(this.successor(), acceptance);
    }

    default public Edge<S> withAcceptance(IntUnaryOperator transformer) {
        NaturalsTransformer iter = new NaturalsTransformer(this.acceptanceSetIterator(), transformer);
        if (!iter.hasNext()) {
            return Edge.of(this.successor());
        }
        int first = iter.nextInt();
        if (!iter.hasNext()) {
            return Edge.of(this.successor(), first);
        }
        BitSet acceptanceSet = BitSets.of((PrimitiveIterator.OfInt)iter);
        acceptanceSet.set(first);
        return this.withAcceptance(acceptanceSet);
    }

    public <T> Edge<T> withSuccessor(T var1);
}

