/*
 * Decompiled with CFR 0.152.
 */
package owl.factories.jbdd;

import de.tum.in.jbdd.Bdd;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import java.util.logging.Logger;

class GcManagedFactory<V> {
    private static final Logger logger = Logger.getLogger(GcManagedFactory.class.getName());
    final Bdd factory;
    private final Int2ObjectMap<BddReference<V>> objects = new Int2ObjectOpenHashMap();
    private final ReferenceQueue<V> queue = new ReferenceQueue();

    GcManagedFactory(Bdd factory) {
        this.factory = factory;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    V canonicalize(int bdd, V object) {
        if (this.factory.isNodeRoot(bdd) || this.factory.isVariableOrNegated(bdd)) {
            assert (this.factory.getReferenceCount(bdd) == -1);
            return object;
        }
        BddReference canonicalReference = (BddReference)this.objects.get(bdd);
        if (canonicalReference != null) {
            assert (this.factory.getReferenceCount(bdd) == 1);
            Object canonicalObject = canonicalReference.get();
            if (canonicalObject != null) return (V)canonicalObject;
            canonicalReference.enqueue();
            this.factory.reference(bdd);
        } else if (this.factory.getReferenceCount(bdd) == 0) {
            this.factory.reference(bdd);
        }
        assert (this.factory.getReferenceCount(bdd) > 0);
        this.clear();
        this.objects.put(bdd, new BddReference(bdd, object, this.queue));
        assert (this.factory.getReferenceCount(bdd) == 1);
        return object;
    }

    private void clear() {
        Reference<V> reference = this.queue.poll();
        if (reference == null) {
            return;
        }
        int count = 0;
        do {
            int bdd = ((BddReference)reference).bdd;
            this.objects.remove(bdd);
            this.factory.dereference(bdd);
            ++count;
        } while ((reference = this.queue.poll()) != null);
        logger.log(Level.FINEST, "Cleared {0} references", count);
    }

    private static final class BddReference<V>
    extends WeakReference<V> {
        private final int bdd;

        private BddReference(int bdd, V object, ReferenceQueue<? super V> queue) {
            super(object, queue);
            this.bdd = bdd;
        }
    }
}

