/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.rewriter;

import java.util.function.Function;
import owl.ltl.Formula;
import owl.ltl.LabelledFormula;
import owl.ltl.rewriter.Fixpoint;
import owl.ltl.rewriter.PullUpXVisitor;
import owl.ltl.rewriter.PushDownXVisitor;
import owl.ltl.rewriter.SyntacticFairnessSimplifier;
import owl.ltl.rewriter.SyntacticSimplifier;

public final class SimplifierFactory {
    private SimplifierFactory() {
    }

    public static Formula applyDefault(Formula formula) {
        return SimplifierFactory.apply(formula, Mode.SYNTACTIC_FIXPOINT);
    }

    public static Formula apply(Formula formula, Mode mode) {
        return (Formula)mode.operation.apply(formula);
    }

    public static Formula apply(Formula formula, Mode ... modes) {
        Formula result = formula;
        for (Mode mode : modes) {
            result = SimplifierFactory.apply(result, mode);
        }
        return result;
    }

    public static LabelledFormula apply(LabelledFormula formula, Mode mode) {
        return formula.wrap(SimplifierFactory.apply(formula.formula(), mode));
    }

    public static LabelledFormula apply(LabelledFormula formula, Mode ... modes) {
        return formula.wrap(SimplifierFactory.apply(formula.formula(), modes));
    }

    public static enum Mode {
        SYNTACTIC(new SyntacticSimplifier()),
        SYNTACTIC_FAIRNESS(SyntacticFairnessSimplifier.NormaliseX.INSTANCE.andThen(SyntacticFairnessSimplifier.INSTANCE)),
        SYNTACTIC_FIXPOINT(new Fixpoint(SyntacticSimplifier.INSTANCE, PullUpXVisitor.INSTANCE)),
        PULL_UP_X(PullUpXVisitor.INSTANCE),
        PUSH_DOWN_X(PushDownXVisitor.INSTANCE),
        NNF(Formula::nnf);

        private final Function<Formula, Formula> operation;

        private Mode(Function<Formula, Formula> operation) {
            this.operation = operation;
        }
    }
}

