/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.ldba2dpa;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import owl.automaton.Automaton;
import owl.automaton.MutableAutomaton;
import owl.automaton.MutableAutomatonUtil;
import owl.automaton.Views;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.algorithms.SccDecomposition;
import owl.automaton.ldba.LimitDeterministicAutomaton;
import owl.automaton.util.AnnotatedState;
import owl.translations.ldba2dpa.Language;
import owl.translations.ldba2dpa.LanguageLattice;

public class AbstractBuilder<S, T, A, L, B extends GeneralizedBuchiAcceptance> {
    @Nullable
    private final List<Set<S>> initialComponentSccs;
    protected final Predicate<? super S> isAcceptingState;
    protected final LanguageLattice<T, A, L> lattice;
    protected final LimitDeterministicAutomaton<S, T, B, A> ldba;
    protected final List<A> safetyComponents;
    protected final List<A> sortingOrder;

    protected AbstractBuilder(LimitDeterministicAutomaton<S, T, B, A> ldba, LanguageLattice<T, A, L> lattice, Predicate<? super S> isAcceptingState, boolean resetAfterSccSwitch) {
        this.initialComponentSccs = resetAfterSccSwitch ? SccDecomposition.computeSccs(ldba.initialComponent()) : null;
        this.lattice = lattice;
        this.ldba = ldba;
        this.sortingOrder = List.copyOf(ldba.components());
        ArrayList<A> safetyBuilder = new ArrayList<A>();
        for (A value : this.sortingOrder) {
            if (!lattice.isSafetyAnnotation(value)) continue;
            safetyBuilder.add(value);
        }
        this.safetyComponents = List.copyOf(safetyBuilder);
        this.isAcceptingState = isAcceptingState;
    }

    public static <S extends AnnotatedState<?>, A extends OmegaAcceptance> Automaton<S, A> optimizeInitialState(Automaton<S, A> readOnly) {
        Object originalInitialState = ((AnnotatedState)readOnly.onlyInitialState()).state();
        MutableAutomaton<AnnotatedState, A> automaton = MutableAutomatonUtil.asMutable(readOnly);
        int size = automaton.size();
        for (Set<S> scc : SccDecomposition.computeSccs(automaton, false)) {
            for (AnnotatedState state : scc) {
                int newSize;
                if (!originalInitialState.equals(state.state()) || !automaton.states().contains(state) || (newSize = Views.replaceInitialState(automaton, Set.of(state)).size()) >= size) continue;
                size = newSize;
                automaton.initialStates(Set.of(state));
                automaton.trim();
            }
        }
        return automaton;
    }

    @Nullable
    protected T findNextSafety(List<T> availableJumps, int i) {
        for (A annotation : this.safetyComponents.subList(i, this.safetyComponents.size())) {
            for (T state : availableJumps) {
                assert (this.lattice.acceptsSafetyLanguage(state));
                A stateAnnotation = this.ldba.annotation(state);
                if (!annotation.equals(stateAnnotation)) continue;
                return state;
            }
        }
        return null;
    }

    protected boolean insertableToRanking(T state, Map<A, Language<L>> existingLanguages) {
        Language<L> existingClass = existingLanguages.get(this.ldba.annotation(state));
        Language<L> stateClass = this.lattice.getLanguage(state);
        return existingClass == null || !existingClass.greaterOrEqual(stateClass);
    }

    protected boolean sccSwitchOccurred(S state, S successor) {
        return this.initialComponentSccs != null && this.initialComponentSccs.stream().anyMatch(x -> x.contains(state) && !x.contains(successor));
    }
}

