/*
 * Decompiled with CFR 0.152.
 */
package jhoafparser.consumer;

import java.io.PrintStream;
import java.util.List;
import jhoafparser.ast.AtomAcceptance;
import jhoafparser.ast.AtomLabel;
import jhoafparser.ast.BooleanExpression;
import jhoafparser.consumer.HOAConsumer;
import jhoafparser.consumer.HOAConsumerException;
import jhoafparser.consumer.HOAConsumerFactory;
import jhoafparser.consumer.HOAIntermediate;

public class HOAIntermediateTrace
extends HOAIntermediate {
    private PrintStream log;

    public HOAIntermediateTrace(HOAConsumer next) {
        this(next, System.out);
    }

    public HOAIntermediateTrace(HOAConsumer next, PrintStream log) {
        super(next);
        this.log = log;
    }

    public static HOAConsumerFactory getFactory(final HOAConsumerFactory next) {
        return new HOAConsumerFactory(){

            @Override
            public HOAConsumer getNewHOAConsumer() {
                return new HOAIntermediateTrace(next.getNewHOAConsumer());
            }
        };
    }

    public static HOAConsumerFactory getFactory(final HOAConsumerFactory next, final PrintStream log) {
        return new HOAConsumerFactory(){

            @Override
            public HOAConsumer getNewHOAConsumer() {
                return new HOAIntermediateTrace(next.getNewHOAConsumer(), log);
            }
        };
    }

    private void trace(String function, Object ... namesAndArguments) {
        this.log.println("=> " + function);
        int i = 0;
        while (i < namesAndArguments.length) {
            this.log.print("      ");
            this.log.print(namesAndArguments[i++]);
            this.log.print(" = ");
            Object argument = namesAndArguments[i++];
            if (argument == null) {
                this.log.print("null");
            } else if (argument instanceof String) {
                this.log.print("\"" + argument + "\"");
            } else {
                this.log.print(argument.toString());
            }
            this.log.println();
        }
    }

    @Override
    public boolean parserResolvesAliases() {
        return this.next.parserResolvesAliases();
    }

    @Override
    public void notifyHeaderStart(String version) throws HOAConsumerException {
        this.trace("notifyHeaderStart", "version", version);
        this.next.notifyHeaderStart(version);
    }

    @Override
    public void setNumberOfStates(int numberOfStates) throws HOAConsumerException {
        this.trace("setNumberOfStates", "numberOfStates", numberOfStates);
        this.next.setNumberOfStates(numberOfStates);
    }

    @Override
    public void addStartStates(List<Integer> stateConjunction) throws HOAConsumerException {
        this.trace("addStartStates", "stateConjunction", stateConjunction);
        this.next.addStartStates(stateConjunction);
    }

    @Override
    public void addAlias(String name, BooleanExpression<AtomLabel> labelExpr) throws HOAConsumerException {
        this.trace("addAlias", "name", name, "labelExpr", labelExpr);
        this.next.addAlias(name, labelExpr);
    }

    @Override
    public void setAPs(List<String> aps) throws HOAConsumerException {
        this.trace("setAPs", "aps", aps);
        this.next.setAPs(aps);
    }

    @Override
    public void setAcceptanceCondition(int numberOfSets, BooleanExpression<AtomAcceptance> accExpr) throws HOAConsumerException {
        this.trace("setAcceptanceCondition", "numberOfSets", numberOfSets, "accExpr", accExpr);
        this.next.setAcceptanceCondition(numberOfSets, accExpr);
    }

    @Override
    public void provideAcceptanceName(String name, List<Object> extraInfo) throws HOAConsumerException {
        this.trace("provideAcceptanceName", "name", name, "extraInfo", extraInfo);
        this.next.provideAcceptanceName(name, extraInfo);
    }

    @Override
    public void setName(String name) throws HOAConsumerException {
        this.trace("setName", "name", name);
        this.next.setName(name);
    }

    @Override
    public void setTool(String name, String version) throws HOAConsumerException {
        this.trace("setTool", "name", name, "version", version);
        this.next.setTool(name, version);
    }

    @Override
    public void addProperties(List<String> properties) throws HOAConsumerException {
        this.trace("addProperties", "properties", properties);
        this.next.addProperties(properties);
    }

    @Override
    public void addMiscHeader(String name, List<Object> content) throws HOAConsumerException {
        this.trace("addMiscHeader", "name", name, "content", content);
        this.next.addMiscHeader(name, content);
    }

    @Override
    public void notifyBodyStart() throws HOAConsumerException {
        this.trace("notifyBodyStart", new Object[0]);
        this.next.notifyBodyStart();
    }

    @Override
    public void addState(int id, String info, BooleanExpression<AtomLabel> labelExpr, List<Integer> accSignature) throws HOAConsumerException {
        this.trace("addState", "id", id, "info", info, "labelExpr", labelExpr, "accSignature", accSignature);
        this.next.addState(id, info, labelExpr, accSignature);
    }

    @Override
    public void addEdgeImplicit(int stateId, List<Integer> conjSuccessors, List<Integer> accSignature) throws HOAConsumerException {
        this.trace("addEdgeImplicit", "stateId", stateId, "conjSuccessors", conjSuccessors, "accSignature", accSignature);
        this.next.addEdgeImplicit(stateId, conjSuccessors, accSignature);
    }

    @Override
    public void addEdgeWithLabel(int stateId, BooleanExpression<AtomLabel> labelExpr, List<Integer> conjSuccessors, List<Integer> accSignature) throws HOAConsumerException {
        this.trace("addEdgeWithLabel", "stateId", stateId, "labelExpr", labelExpr, "conjSuccessors", conjSuccessors, "accSignature", accSignature);
        this.next.addEdgeWithLabel(stateId, labelExpr, conjSuccessors, accSignature);
    }

    @Override
    public void notifyEndOfState(int stateId) throws HOAConsumerException {
        this.trace("notifyEndOfState", "stateId", stateId);
        this.next.notifyEndOfState(stateId);
    }

    @Override
    public void notifyEnd() throws HOAConsumerException {
        this.trace("notifyEnd", new Object[0]);
        this.next.notifyEnd();
    }

    @Override
    public void notifyAbort() {
        this.trace("notifyAbort", new Object[0]);
        this.next.notifyAbort();
    }

    @Override
    public void notifyWarning(String warning) throws HOAConsumerException {
        this.trace("notifyWarning", "warning", warning);
        this.next.notifyWarning(warning);
    }
}

