/*
 * Decompiled with CFR 0.152.
 */
package jhoafparser.storage;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import jhoafparser.ast.AtomLabel;
import jhoafparser.ast.BooleanExpression;
import jhoafparser.consumer.HOAConsumer;
import jhoafparser.consumer.HOAConsumerException;
import jhoafparser.storage.StoredEdgeImplicit;
import jhoafparser.storage.StoredEdgeWithLabel;
import jhoafparser.storage.StoredHeader;
import jhoafparser.storage.StoredState;
import jhoafparser.storage.UniqueTable;

public class StoredAutomaton {
    private UniqueTable<List<Integer>> acceptanceSignatures;
    private UniqueTable<BooleanExpression<AtomLabel>> labelExpressions;
    private UniqueTable<StoredEdgeImplicit> edgesImplicit = new UniqueTable();
    private UniqueTable<StoredEdgeWithLabel> edgesWithLabel = new UniqueTable();
    private TreeMap<Integer, ArrayList<StoredEdgeImplicit>> stateToImplicitEdges;
    private TreeMap<Integer, ArrayList<StoredEdgeWithLabel>> stateToEdgesWithLabel;
    private TreeMap<Integer, StoredState> indexToState;
    private StoredHeader storedHeader;

    public StoredAutomaton() {
        this.acceptanceSignatures = new UniqueTable();
        this.labelExpressions = new UniqueTable();
        this.stateToImplicitEdges = new TreeMap();
        this.stateToEdgesWithLabel = new TreeMap();
        this.indexToState = new TreeMap();
        this.storedHeader = new StoredHeader();
    }

    public void addState(StoredState state) throws UnsupportedOperationException {
        Integer stateId = state.getStateId();
        if (this.indexToState.containsKey(stateId)) {
            throw new UnsupportedOperationException("Duplicate state (id = " + stateId + ")");
        }
        this.indexToState.put(stateId, state);
    }

    public void addEdgeImplicit(int stateId, StoredEdgeImplicit edge) {
        edge = this.edgesImplicit.findOrAdd(edge);
        ArrayList<StoredEdgeImplicit> edges = this.stateToImplicitEdges.get(stateId);
        if (edges == null) {
            edges = new ArrayList();
            this.stateToImplicitEdges.put(stateId, edges);
        }
        edges.add(edge);
    }

    public void addEdgeWithLabel(int stateId, StoredEdgeWithLabel edge) {
        edge = this.edgesWithLabel.findOrAdd(edge);
        ArrayList<StoredEdgeWithLabel> edges = this.stateToEdgesWithLabel.get(stateId);
        if (edges == null) {
            edges = new ArrayList();
            this.stateToEdgesWithLabel.put(stateId, edges);
        }
        edges.add(edge);
    }

    public void clearEdgesWithLabel(int stateId) {
        this.stateToEdgesWithLabel.remove(stateId);
    }

    public void clearEdgesImplicit(int stateId) {
        this.stateToImplicitEdges.remove(stateId);
    }

    public void setStoredHeader(StoredHeader header) {
        this.storedHeader = header;
    }

    public StoredHeader getStoredHeader() {
        return this.storedHeader;
    }

    public StoredState getStoredState(int stateId) {
        return this.indexToState.get(stateId);
    }

    public Iterable<StoredState> getStoredStates() {
        return this.indexToState.values();
    }

    public int getNumberOfStates() {
        return this.indexToState.size();
    }

    public int getHighestStateIndex() {
        return this.indexToState.lastKey();
    }

    public Iterable<StoredEdgeImplicit> getEdgesImplicit(int stateId) {
        return this.stateToImplicitEdges.get(stateId);
    }

    public Iterable<StoredEdgeWithLabel> getEdgesWithLabel(int stateId) {
        return this.stateToEdgesWithLabel.get(stateId);
    }

    public boolean hasState(int stateId) {
        return this.indexToState.containsKey(stateId);
    }

    public boolean hasEdgesImplicit(int stateId) {
        return this.stateToImplicitEdges.containsKey(stateId);
    }

    public boolean hasEdgesWithLabel(int stateId) {
        return this.stateToEdgesWithLabel.containsKey(stateId);
    }

    public BooleanExpression<AtomLabel> findOrAdd(BooleanExpression<AtomLabel> exprLabel) {
        if (exprLabel == null) {
            return null;
        }
        return this.labelExpressions.findOrAdd(exprLabel);
    }

    public List<Integer> findOrAdd(List<Integer> acceptanceSignature) {
        if (acceptanceSignature == null) {
            return null;
        }
        return this.acceptanceSignatures.findOrAdd(acceptanceSignature);
    }

    public void feedToConsumer(HOAConsumer c) throws HOAConsumerException {
        c.notifyHeaderStart("v1");
        this.storedHeader.feedToConsumer(c);
        c.notifyBodyStart();
        this.feedTransitionStructureToConsumer(c);
        c.notifyEnd();
    }

    public static void feedEdgesImplicitToConsumer(HOAConsumer consumer, int stateId, List<StoredEdgeImplicit> edges) throws HOAConsumerException {
        for (StoredEdgeImplicit edge : edges) {
            consumer.addEdgeImplicit(stateId, edge.getConjSuccessors(), edge.getAccSignature());
        }
    }

    public static void feedEdgesWithLabelToConsumer(HOAConsumer consumer, int stateId, List<StoredEdgeWithLabel> edges) throws HOAConsumerException {
        for (StoredEdgeWithLabel edge : edges) {
            consumer.addEdgeWithLabel(stateId, edge.getLabelExpr(), edge.getConjSuccessors(), edge.getAccSignature());
        }
    }

    public static void feedEdgesToConsumer(HOAConsumer consumer, int stateId, List<StoredEdgeImplicit> edgesImplicit, List<StoredEdgeWithLabel> edgesWithLabel) throws HOAConsumerException {
        if (edgesImplicit != null) {
            if (edgesWithLabel != null) {
                throw new HOAConsumerException("Both explicit and implicit edges for state " + stateId);
            }
            StoredAutomaton.feedEdgesImplicitToConsumer(consumer, stateId, edgesImplicit);
        } else if (edgesWithLabel != null) {
            StoredAutomaton.feedEdgesWithLabelToConsumer(consumer, stateId, edgesWithLabel);
        }
    }

    public void feedTransitionStructureToConsumer(HOAConsumer consumer) throws HOAConsumerException {
        for (StoredState s : this.indexToState.values()) {
            consumer.addState(s.getStateId(), s.getInfo(), s.getLabelExpr(), s.getAccSignature());
            StoredAutomaton.feedEdgesToConsumer(consumer, s.getStateId(), (List<StoredEdgeImplicit>)this.stateToImplicitEdges.get(s.getStateId()), (List<StoredEdgeWithLabel>)this.stateToEdgesWithLabel.get(s.getStateId()));
            consumer.notifyEndOfState(s.getStateId());
        }
    }

    public boolean hasUniversalBranching() {
        if (this.storedHeader != null) {
            for (List<Integer> list : this.storedHeader.getStartStates()) {
                if (list.size() == 1) continue;
                return true;
            }
        }
        for (ArrayList arrayList : this.stateToImplicitEdges.values()) {
            for (Object edges : arrayList) {
                if (((StoredEdgeImplicit)edges).getConjSuccessors().size() == 1) continue;
                return true;
            }
        }
        for (ArrayList arrayList : this.stateToEdgesWithLabel.values()) {
            for (Object edges : arrayList) {
                if (((StoredEdgeWithLabel)edges).getConjSuccessors().size() == 1) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasEdgesImplicit() {
        for (ArrayList<StoredEdgeImplicit> edgeList : this.stateToImplicitEdges.values()) {
            if (edgeList.size() <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasEdgesWithLabel() {
        for (ArrayList<StoredEdgeWithLabel> edgeList : this.stateToEdgesWithLabel.values()) {
            if (edgeList.size() <= 0) continue;
            return true;
        }
        return false;
    }
}

