/*
 * Decompiled with CFR 0.152.
 */
package jhoafparser.transformations;

import java.util.ArrayList;
import java.util.List;
import jhoafparser.ast.AtomLabel;
import jhoafparser.ast.BooleanExpression;
import jhoafparser.consumer.HOAConsumerException;
import jhoafparser.storage.StoredAutomaton;
import jhoafparser.storage.StoredAutomatonManipulator;
import jhoafparser.storage.StoredEdgeImplicit;
import jhoafparser.storage.StoredEdgeWithLabel;
import jhoafparser.storage.UniqueTable;
import jhoafparser.util.ImplicitEdgeHelper;

public class ToExplicitLabels
implements StoredAutomatonManipulator {
    private boolean preferToUseAliases = false;
    private List<BooleanExpression<AtomLabel>> explicitForImplicit;

    public ToExplicitLabels(boolean preferToUseAliases) {
        this.preferToUseAliases = preferToUseAliases;
    }

    private void prepareExpressions(ImplicitEdgeHelper implicitHelper, StoredAutomaton aut) throws HOAConsumerException {
        this.explicitForImplicit = new ArrayList<BooleanExpression<AtomLabel>>((int)implicitHelper.getEdgesPerState());
        if (implicitHelper.getEdgesPerState() > Integer.MAX_VALUE) {
            throw new HOAConsumerException("Too many atomic propositions...");
        }
        UniqueTable<BooleanExpression<AtomLabel>> uniqueTable = new UniqueTable<BooleanExpression<AtomLabel>>();
        for (long i = 0L; i < implicitHelper.getEdgesPerState(); ++i) {
            BooleanExpression<AtomLabel> expr = implicitHelper.toExplicitLabel(i, uniqueTable);
            if (this.preferToUseAliases) {
                String name = "i" + i;
                while (aut.getStoredHeader().hasAlias(name)) {
                    name = "_" + name;
                }
                aut.getStoredHeader().addAlias(name, expr);
                this.explicitForImplicit.add(new BooleanExpression<AtomLabel>(AtomLabel.createAlias(name)));
                continue;
            }
            this.explicitForImplicit.add(expr);
        }
    }

    private void convert(StoredAutomaton aut) throws HOAConsumerException {
        ImplicitEdgeHelper implicitHelper = new ImplicitEdgeHelper(aut.getStoredHeader().getAPs().size());
        for (int stateId = 0; stateId <= aut.getHighestStateIndex(); ++stateId) {
            if (!aut.hasEdgesImplicit(stateId)) continue;
            if (this.explicitForImplicit == null) {
                this.prepareExpressions(implicitHelper, aut);
            }
            int implicitEdge = 0;
            for (StoredEdgeImplicit edge : aut.getEdgesImplicit(stateId)) {
                aut.addEdgeWithLabel(stateId, new StoredEdgeWithLabel(this.explicitForImplicit.get(implicitEdge), edge.getConjSuccessors(), edge.getAccSignature()));
                ++implicitEdge;
            }
            aut.clearEdgesImplicit(stateId);
        }
    }

    @Override
    public StoredAutomaton manipulate(StoredAutomaton aut) throws HOAConsumerException {
        this.convert(aut);
        return aut;
    }
}

