/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import owl.automaton.Automaton;
import owl.automaton.ImmutableViewSettings;
import owl.automaton.Views;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.algorithms.LanguageEmptiness;
import owl.automaton.algorithms.SccDecomposition;
import owl.automaton.edge.Edge;
import owl.collections.ValuationSet;
import owl.factories.ValuationSetFactory;

public final class AutomatonUtil {
    private AutomatonUtil() {
    }

    public static Automaton<Object, OmegaAcceptance> cast(Object automaton) {
        return AutomatonUtil.cast(automaton, OmegaAcceptance.class);
    }

    public static <A extends OmegaAcceptance> Automaton<Object, A> cast(Object automaton, Class<A> acceptanceClass) {
        return AutomatonUtil.cast(automaton, Object.class, acceptanceClass);
    }

    public static <S, A extends OmegaAcceptance> Automaton<S, A> cast(Object automaton, Class<S> stateClass, Class<A> acceptanceClass) {
        Preconditions.checkArgument((boolean)(automaton instanceof Automaton), (String)"Expected automaton, got %s", (Object)automaton.getClass().getName());
        Automaton castedAutomaton = (Automaton)automaton;
        AutomatonUtil.checkAcceptanceClass(castedAutomaton, acceptanceClass);
        assert (AutomatonUtil.checkStateClass(castedAutomaton, stateClass));
        return castedAutomaton;
    }

    public static <S, A extends OmegaAcceptance> Automaton<S, A> cast(Automaton<S, ?> automaton, Class<A> acceptanceClass) {
        AutomatonUtil.checkAcceptanceClass(automaton, acceptanceClass);
        return automaton;
    }

    private static <S> void checkAcceptanceClass(Automaton<S, ?> automaton, Class<?> clazz) {
        Preconditions.checkArgument((boolean)clazz.isInstance(automaton.acceptance()), (String)"Expected acceptance type %s, got %s", (Object)clazz.getName(), automaton.acceptance().getClass());
    }

    private static <S> boolean checkStateClass(Automaton<S, ?> automaton, Class<?> clazz) {
        if (Object.class.equals(clazz)) {
            return true;
        }
        for (S state : automaton.states()) {
            Preconditions.checkArgument((boolean)clazz.isInstance(state), (String)"Expected states of type %s but got %s.", (Object)clazz.getName(), (Object)state.getClass().getName());
        }
        return true;
    }

    public static <S> void forEachNonTransientEdge(Automaton<S, ?> automaton, BiConsumer<S, Edge<S>> action) {
        List<Set<S>> sccs = SccDecomposition.computeSccs(automaton, false);
        for (Set scc : sccs) {
            for (Object state : scc) {
                automaton.edges(state).forEach(edge -> {
                    if (scc.contains(edge.successor())) {
                        action.accept(state, (Edge)edge);
                    }
                });
            }
        }
    }

    public static <S> Map<S, ValuationSet> getIncompleteStates(final Automaton<S, ?> automaton) {
        final HashMap incompleteStates = new HashMap();
        Automaton.EdgeMapVisitor visitor = new Automaton.EdgeMapVisitor<S>(){
            private final ValuationSetFactory factory;
            {
                this.factory = automaton.factory();
            }

            @Override
            public void visit(S state, Map<Edge<S>, ValuationSet> edgeMap) {
                ValuationSet set = this.factory.union(edgeMap.values());
                if (!set.isUniverse()) {
                    incompleteStates.put(state, set.complement());
                }
            }
        };
        automaton.accept(visitor);
        return incompleteStates;
    }

    public static <S> Set<S> getNondeterministicStates(final Automaton<S, ?> automaton) {
        final HashSet nondeterministicStates = new HashSet();
        Automaton.EdgeMapVisitor visitor = new Automaton.EdgeMapVisitor<S>(){
            private final ValuationSet emptyValuationSet;
            {
                this.emptyValuationSet = automaton.factory().empty();
            }

            @Override
            public void visit(S state, Map<Edge<S>, ValuationSet> edgeMap) {
                ValuationSet union = this.emptyValuationSet;
                for (ValuationSet valuationSet : edgeMap.values()) {
                    if (union.intersects(valuationSet)) {
                        nondeterministicStates.add(state);
                        return;
                    }
                    union = union.union(valuationSet);
                }
            }
        };
        automaton.accept(visitor);
        return nondeterministicStates;
    }

    public static <S> BitSet getAcceptanceSets(Automaton<S, ?> automaton, Set<S> states) {
        BitSet set = new BitSet();
        for (S state : states) {
            automaton.edges(state).forEach(edge -> {
                if (states.contains(edge.successor())) {
                    edge.acceptanceSetIterator().forEachRemaining(set::set);
                }
            });
        }
        return set;
    }

    public static <S> BitSet getAcceptanceSets(Automaton<S, ?> automaton) {
        BitSet indices = new BitSet();
        switch (automaton.preferredEdgeAccess().get(0)) {
            case EDGES: {
                automaton.accept((state, valuation, edge) -> edge.acceptanceSetIterator().forEachRemaining(indices::set));
                break;
            }
            case EDGE_MAP: {
                automaton.accept((state, edgeMap) -> edgeMap.forEach((edge, set) -> edge.acceptanceSetIterator().forEachRemaining(indices::set)));
                break;
            }
            case EDGE_TREE: {
                automaton.accept((state, tree) -> tree.values().forEach(edge -> edge.acceptanceSetIterator().forEachRemaining(indices::set)));
                break;
            }
            default: {
                throw new AssertionError((Object)"Unreable.");
            }
        }
        return indices;
    }

    public static <S, B extends GeneralizedBuchiAcceptance> Optional<Set<S>> ldbaSplit(Automaton<S, B> automaton) {
        HashSet<S> acceptingSccs = new HashSet<S>();
        for (Set<S> scc : SccDecomposition.computeSccs(automaton)) {
            ImmutableViewSettings viewSettings = Views.builder().initialStates(Set.of(scc.iterator().next())).stateFilter(scc::contains).build();
            if (LanguageEmptiness.isEmpty(Views.createView(automaton, viewSettings))) continue;
            acceptingSccs.addAll(scc);
        }
        Automaton<S, B> acceptingComponentAutomaton = Views.replaceInitialState(automaton, acceptingSccs);
        return acceptingComponentAutomaton.is(Automaton.Property.SEMI_DETERMINISTIC) ? Optional.of(Sets.difference(automaton.states(), acceptingComponentAutomaton.states())) : Optional.empty();
    }
}

