/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.acceptance;

import java.util.BitSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.IntStream;
import javax.annotation.Nonnegative;
import jhoafparser.ast.AtomAcceptance;
import jhoafparser.ast.BooleanExpression;
import owl.automaton.acceptance.BooleanExpressions;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.edge.Edge;

public class GeneralizedBuchiAcceptance
extends OmegaAcceptance {
    @Nonnegative
    public final int size;

    GeneralizedBuchiAcceptance(int size) {
        this.size = size;
    }

    public static GeneralizedBuchiAcceptance of(int size) {
        return size == 1 ? BuchiAcceptance.INSTANCE : new GeneralizedBuchiAcceptance(size);
    }

    @Override
    public final int acceptanceSets() {
        return this.size;
    }

    @Override
    public BooleanExpression<AtomAcceptance> booleanExpression() {
        return BooleanExpressions.createConjunction(IntStream.range(0, this.size).mapToObj(BooleanExpressions::mkInf));
    }

    @Override
    public String name() {
        return "generalized-Buchi";
    }

    @Override
    public List<Object> nameExtra() {
        return List.of(Integer.valueOf(this.size));
    }

    @Override
    public BitSet acceptingSet() {
        BitSet set = new BitSet();
        set.set(0, this.size);
        return set;
    }

    @Override
    public BitSet rejectingSet() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return new BitSet();
    }

    @Override
    public boolean isWellFormedEdge(Edge<?> edge) {
        return edge.largestAcceptanceSet() < this.size;
    }
}

