/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import owl.collections.ValuationTree;
import owl.factories.EquivalenceClassFactory;
import owl.ltl.Formula;
import owl.ltl.LtlLanguageExpressible;

public class EquivalenceClass
implements LtlLanguageExpressible {
    private final EquivalenceClassFactory factory;
    @Nullable
    private final Formula representative;

    protected EquivalenceClass(EquivalenceClassFactory factory, @Nullable Formula representative) {
        this.factory = factory;
        this.representative = representative;
    }

    @Nullable
    public final Formula representative() {
        return this.representative;
    }

    public final EquivalenceClassFactory factory() {
        return this.factory;
    }

    public final boolean isFalse() {
        return this.equals(this.factory.getFalse());
    }

    public final boolean isTrue() {
        return this.equals(this.factory.getTrue());
    }

    public final BitSet atomicPropositions() {
        return this.factory.atomicPropositions(this, false);
    }

    public final BitSet atomicPropositions(boolean includeNested) {
        return this.factory.atomicPropositions(this, includeNested);
    }

    public final Set<Formula.ModalOperator> modalOperators() {
        return this.factory.modalOperators(this);
    }

    public final boolean implies(EquivalenceClass other) {
        return this.factory.implies(this, other);
    }

    public final EquivalenceClass and(EquivalenceClass other) {
        return this.factory.conjunction(Arrays.asList(this, other));
    }

    public final EquivalenceClass or(EquivalenceClass other) {
        return this.factory.disjunction(Arrays.asList(this, other));
    }

    public final EquivalenceClass substitute(Function<? super Formula.ModalOperator, ? extends Formula> substitution) {
        return this.factory.substitute(this, substitution);
    }

    public final EquivalenceClass temporalStep(BitSet valuation) {
        return this.factory.temporalStep(this, valuation);
    }

    public final ValuationTree<EquivalenceClass> temporalStepTree() {
        return this.temporalStepTree(Set::of);
    }

    public final <T> ValuationTree<T> temporalStepTree(Function<EquivalenceClass, Set<T>> mapper) {
        return this.factory.temporalStepTree(this, mapper);
    }

    public final EquivalenceClass temporalStepUnfold(BitSet valuation) {
        return this.factory.temporalStepUnfold(this, valuation);
    }

    public final EquivalenceClass unfold() {
        return this.factory.unfold(this);
    }

    public final EquivalenceClass unfoldTemporalStep(BitSet valuation) {
        return this.factory.unfoldTemporalStep(this, valuation);
    }

    public final double trueness() {
        return this.factory.trueness(this);
    }

    @Override
    public EquivalenceClass language() {
        return this;
    }

    public final String toString() {
        return this.factory.toString(this);
    }
}

