/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.fgx2dpa;

import com.google.common.collect.Sets;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;
import org.immutables.value.Value;
import owl.ltl.Formula;
import owl.ltl.UnaryModalOperator;
import owl.translations.fgx2dpa.MonitorTuple;
import owl.translations.fgx2dpa.SafetyAutomaton;
import owl.util.annotation.HashedTuple;

@Value.Immutable
@HashedTuple
public abstract class Monitor<F extends UnaryModalOperator> {
    abstract F formula();

    abstract Set<Formula> currentTokens();

    @Value.Derived
    @Value.Auxiliary
    Set<Formula> finalStates() {
        return Sets.filter(this.currentTokens(), t -> t.accept(SafetyAutomaton.FinalStateVisitor.INSTANCE));
    }

    @Value.Derived
    @Value.Auxiliary
    Set<Formula> nonFinalStates() {
        return Sets.difference(this.currentTokens(), this.finalStates());
    }

    public static <F extends UnaryModalOperator> Monitor<F> of(F formula, Set<Formula> currentTokens) {
        return MonitorTuple.create(formula, currentTokens);
    }

    public static <F extends UnaryModalOperator> Monitor<F> of(F formula) {
        return Monitor.of(formula, Set.of(formula.operand));
    }

    public Monitor<F> temporalStep(BitSet valuation) {
        HashSet<Formula> currentTokens = new HashSet<Formula>(Set.of(((UnaryModalOperator)this.formula()).operand));
        this.nonFinalStates().forEach(t -> currentTokens.add(t.temporalStep(valuation)));
        return Monitor.of(this.formula(), currentTokens);
    }
}

