/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.nba2ldba;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;
import owl.automaton.Automaton;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.translations.nba2ldba.NBA2LDBA;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="NBA2LDBA.LDBA", generator="Immutables")
@Immutable
final class LDBATuple<S>
extends NBA2LDBA.LDBA<S> {
    private final Automaton<S, BuchiAcceptance> automaton;
    private final ImmutableSet<S> initialComponent;
    private final transient int hashCode;

    private LDBATuple(Automaton<S, BuchiAcceptance> automaton, Iterable<? extends S> initialComponent) {
        this.automaton = Objects.requireNonNull(automaton, "automaton");
        this.initialComponent = ImmutableSet.copyOf(initialComponent);
        this.hashCode = this.computeHashCode();
    }

    @Override
    public Automaton<S, BuchiAcceptance> automaton() {
        return this.automaton;
    }

    @Override
    public ImmutableSet<S> initialComponent() {
        return this.initialComponent;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof LDBATuple && this.equalTo((LDBATuple)another);
    }

    private boolean equalTo(LDBATuple<?> another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.automaton.equals(another.automaton) && this.initialComponent.equals(another.initialComponent);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.automaton.hashCode();
        h += (h << 5) + this.initialComponent.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"LDBA").omitNullValues().add("automaton", this.automaton).add("initialComponent", this.initialComponent).toString();
    }

    public static <S> LDBATuple<S> create(Automaton<S, BuchiAcceptance> automaton, Set<S> initialComponent) {
        return LDBATuple.create(automaton, initialComponent);
    }

    public static <S> LDBATuple<S> create(Automaton<S, BuchiAcceptance> automaton, Iterable<? extends S> initialComponent) {
        return new LDBATuple<S>(automaton, initialComponent);
    }
}

