/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.rabinizer;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nullable;
import owl.factories.EquivalenceClassFactory;
import owl.ltl.Conjunction;
import owl.ltl.EquivalenceClass;
import owl.ltl.GOperator;

final class GSet
extends AbstractSet<GOperator> {
    @Nullable
    private final EquivalenceClass conjunction;
    private final Set<GOperator> elements;
    private final int hashCode;
    @Nullable
    private final EquivalenceClass operatorConjunction;

    GSet(Collection<GOperator> elements, EquivalenceClassFactory factory) {
        this.elements = Set.copyOf(elements);
        this.conjunction = factory.of(Conjunction.of(elements));
        this.operatorConjunction = factory.of(Conjunction.of(elements.stream().map(x -> x.operand)));
        this.hashCode = this.elements.hashCode();
    }

    GSet(Set<GOperator> elements) {
        this.elements = elements;
        this.operatorConjunction = null;
        this.conjunction = null;
        this.hashCode = this.elements.hashCode();
    }

    EquivalenceClass conjunction() {
        Preconditions.checkState((this.conjunction != null ? 1 : 0) != 0);
        return this.conjunction;
    }

    @Override
    public boolean contains(Object o) {
        return this.elements.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.elements.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof GSet) {
            GSet other = (GSet)o;
            return this.conjunction == null || other.conjunction == null ? this.elements.equals(other.elements) : this.conjunction.equals(other.conjunction);
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        assert (this.hashCode == this.elements.hashCode());
        return this.hashCode;
    }

    public GSet intersection(GSet other) {
        return new GSet((Set<GOperator>)Sets.intersection(this.elements, other.elements));
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public Iterator<GOperator> iterator() {
        return Iterators.unmodifiableIterator(this.elements.iterator());
    }

    EquivalenceClass operatorConjunction() {
        Preconditions.checkState((this.operatorConjunction != null ? 1 : 0) != 0);
        return this.operatorConjunction;
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public String toString() {
        return this.elements.toString();
    }
}

