/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import owl.automaton.Automaton;
import owl.automaton.Views;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.edge.Edge;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Views.ViewSettings", generator="Immutables")
@Immutable
final class ImmutableViewSettings<S, A extends OmegaAcceptance>
extends Views.ViewSettings<S, A> {
    @Nullable
    private final A acceptance;
    @Nullable
    private final ImmutableSet<S> initialStates;
    @Nullable
    private final Predicate<S> stateFilter;
    @Nullable
    private final Predicate<Edge<S>> edgeFilter;
    @Nullable
    private final Function<Edge<S>, Edge<S>> edgeRewriter;
    private final ImmutableMap<Automaton.Property, Boolean> properties;

    private ImmutableViewSettings(Builder<S, A> builder) {
        this.acceptance = builder.acceptance;
        this.initialStates = builder.initialStates == null ? null : builder.initialStates.build();
        this.stateFilter = builder.stateFilter;
        this.edgeFilter = builder.edgeFilter;
        this.edgeRewriter = builder.edgeRewriter;
        this.properties = builder.propertiesIsSet() ? Maps.immutableEnumMap((Map)builder.properties.build()) : Maps.immutableEnumMap(super.properties());
    }

    private ImmutableViewSettings(@Nullable A acceptance, @Nullable ImmutableSet<S> initialStates, @Nullable Predicate<S> stateFilter, @Nullable Predicate<Edge<S>> edgeFilter, @Nullable Function<Edge<S>, Edge<S>> edgeRewriter, ImmutableMap<Automaton.Property, Boolean> properties) {
        this.acceptance = acceptance;
        this.initialStates = initialStates;
        this.stateFilter = stateFilter;
        this.edgeFilter = edgeFilter;
        this.edgeRewriter = edgeRewriter;
        this.properties = properties;
    }

    @Override
    @Nullable
    A acceptance() {
        return this.acceptance;
    }

    @Override
    @Nullable
    ImmutableSet<S> initialStates() {
        return this.initialStates;
    }

    @Override
    @Nullable
    Predicate<S> stateFilter() {
        return this.stateFilter;
    }

    @Override
    @Nullable
    Predicate<Edge<S>> edgeFilter() {
        return this.edgeFilter;
    }

    @Override
    @Nullable
    Function<Edge<S>, Edge<S>> edgeRewriter() {
        return this.edgeRewriter;
    }

    ImmutableMap<Automaton.Property, Boolean> properties() {
        return this.properties;
    }

    public final ImmutableViewSettings<S, A> withAcceptance(@Nullable A value) {
        if (this.acceptance == value) {
            return this;
        }
        return new ImmutableViewSettings<S, A>(value, this.initialStates, this.stateFilter, this.edgeFilter, this.edgeRewriter, this.properties);
    }

    @SafeVarargs
    public final ImmutableViewSettings<S, A> withInitialStates(S ... elements) {
        if (elements == null) {
            return new ImmutableViewSettings<S, A>(this.acceptance, null, this.stateFilter, this.edgeFilter, this.edgeRewriter, this.properties);
        }
        ImmutableSet newValue = elements == null ? null : ImmutableSet.copyOf((Object[])elements);
        return new ImmutableViewSettings<S, A>(this.acceptance, newValue, this.stateFilter, this.edgeFilter, this.edgeRewriter, this.properties);
    }

    public final ImmutableViewSettings<S, A> withInitialStates(@Nullable Iterable<? extends S> elements) {
        if (this.initialStates == elements) {
            return this;
        }
        ImmutableSet newValue = elements == null ? null : ImmutableSet.copyOf(elements);
        return new ImmutableViewSettings<S, A>(this.acceptance, newValue, this.stateFilter, this.edgeFilter, this.edgeRewriter, this.properties);
    }

    public final ImmutableViewSettings<S, A> withStateFilter(@Nullable Predicate<S> value) {
        if (this.stateFilter == value) {
            return this;
        }
        return new ImmutableViewSettings<S, A>(this.acceptance, this.initialStates, value, this.edgeFilter, this.edgeRewriter, this.properties);
    }

    public final ImmutableViewSettings<S, A> withEdgeFilter(@Nullable Predicate<Edge<S>> value) {
        if (this.edgeFilter == value) {
            return this;
        }
        return new ImmutableViewSettings<S, A>(this.acceptance, this.initialStates, this.stateFilter, value, this.edgeRewriter, this.properties);
    }

    public final ImmutableViewSettings<S, A> withEdgeRewriter(@Nullable Function<Edge<S>, Edge<S>> value) {
        if (this.edgeRewriter == value) {
            return this;
        }
        return new ImmutableViewSettings<S, A>(this.acceptance, this.initialStates, this.stateFilter, this.edgeFilter, value, this.properties);
    }

    public final ImmutableViewSettings<S, A> withProperties(Map<Automaton.Property, ? extends Boolean> entries) {
        if (this.properties == entries) {
            return this;
        }
        ImmutableMap newValue = Maps.immutableEnumMap(entries);
        return new ImmutableViewSettings<S, A>(this.acceptance, this.initialStates, this.stateFilter, this.edgeFilter, this.edgeRewriter, (ImmutableMap<Automaton.Property, Boolean>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableViewSettings && this.equalTo((ImmutableViewSettings)another);
    }

    private boolean equalTo(ImmutableViewSettings<?, ?> another) {
        return Objects.equals(this.acceptance, another.acceptance) && Objects.equals(this.initialStates, another.initialStates) && Objects.equals(this.stateFilter, another.stateFilter) && Objects.equals(this.edgeFilter, another.edgeFilter) && Objects.equals(this.edgeRewriter, another.edgeRewriter) && this.properties.equals(another.properties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.acceptance);
        h += (h << 5) + Objects.hashCode(this.initialStates);
        h += (h << 5) + Objects.hashCode(this.stateFilter);
        h += (h << 5) + Objects.hashCode(this.edgeFilter);
        h += (h << 5) + Objects.hashCode(this.edgeRewriter);
        h += (h << 5) + this.properties.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ViewSettings").omitNullValues().add("acceptance", this.acceptance).add("initialStates", this.initialStates).add("stateFilter", this.stateFilter).add("edgeFilter", this.edgeFilter).add("edgeRewriter", this.edgeRewriter).add("properties", this.properties).toString();
    }

    public static <S, A extends OmegaAcceptance> ImmutableViewSettings<S, A> copyOf(Views.ViewSettings<S, A> instance) {
        if (instance instanceof ImmutableViewSettings) {
            return (ImmutableViewSettings)instance;
        }
        return ImmutableViewSettings.builder().from(instance).build();
    }

    public static <S, A extends OmegaAcceptance> Builder<S, A> builder() {
        return new Builder();
    }

    @Generated(from="Views.ViewSettings", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<S, A extends OmegaAcceptance> {
        private static final long OPT_BIT_PROPERTIES = 1L;
        private long optBits;
        @Nullable
        private A acceptance;
        private ImmutableSet.Builder<S> initialStates = null;
        @Nullable
        private Predicate<S> stateFilter;
        @Nullable
        private Predicate<Edge<S>> edgeFilter;
        @Nullable
        private Function<Edge<S>, Edge<S>> edgeRewriter;
        private ImmutableMap.Builder<Automaton.Property, Boolean> properties = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<S, A> from(Views.ViewSettings<S, A> instance) {
            Function<Edge<S>, Edge<S>> edgeRewriterValue;
            Predicate<Edge<S>> edgeFilterValue;
            Predicate<S> stateFilterValue;
            Set<S> initialStatesValue;
            Objects.requireNonNull(instance, "instance");
            A acceptanceValue = instance.acceptance();
            if (acceptanceValue != null) {
                this.acceptance(acceptanceValue);
            }
            if ((initialStatesValue = instance.initialStates()) != null) {
                this.addAllInitialStates(initialStatesValue);
            }
            if ((stateFilterValue = instance.stateFilter()) != null) {
                this.stateFilter(stateFilterValue);
            }
            if ((edgeFilterValue = instance.edgeFilter()) != null) {
                this.edgeFilter(edgeFilterValue);
            }
            if ((edgeRewriterValue = instance.edgeRewriter()) != null) {
                this.edgeRewriter(edgeRewriterValue);
            }
            this.putAllProperties(instance.properties());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<S, A> acceptance(@Nullable A acceptance) {
            this.acceptance = acceptance;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<S, A> addInitialStates(S element) {
            if (this.initialStates == null) {
                this.initialStates = ImmutableSet.builder();
            }
            this.initialStates.add(element);
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder<S, A> addInitialStates(S ... elements) {
            if (this.initialStates == null) {
                this.initialStates = ImmutableSet.builder();
            }
            this.initialStates.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<S, A> initialStates(@Nullable Iterable<? extends S> elements) {
            if (elements == null) {
                this.initialStates = null;
                return this;
            }
            this.initialStates = ImmutableSet.builder();
            return this.addAllInitialStates(elements);
        }

        @CanIgnoreReturnValue
        public final Builder<S, A> addAllInitialStates(Iterable<? extends S> elements) {
            Objects.requireNonNull(elements, "initialStates element");
            if (this.initialStates == null) {
                this.initialStates = ImmutableSet.builder();
            }
            this.initialStates.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<S, A> stateFilter(@Nullable Predicate<S> stateFilter) {
            this.stateFilter = stateFilter;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<S, A> edgeFilter(@Nullable Predicate<Edge<S>> edgeFilter) {
            this.edgeFilter = edgeFilter;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<S, A> edgeRewriter(@Nullable Function<Edge<S>, Edge<S>> edgeRewriter) {
            this.edgeRewriter = edgeRewriter;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<S, A> putProperties(Automaton.Property key, boolean value) {
            this.properties.put((Object)key, (Object)value);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<S, A> putProperties(Map.Entry<Automaton.Property, ? extends Boolean> entry) {
            this.properties.put(entry);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<S, A> properties(Map<Automaton.Property, ? extends Boolean> entries) {
            this.properties = ImmutableMap.builder();
            this.optBits |= 1L;
            return this.putAllProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder<S, A> putAllProperties(Map<Automaton.Property, ? extends Boolean> entries) {
            this.properties.putAll(entries);
            this.optBits |= 1L;
            return this;
        }

        public ImmutableViewSettings<S, A> build() {
            return new ImmutableViewSettings(this);
        }

        private boolean propertiesIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

