/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.rewriter;

import java.util.function.Function;
import java.util.function.UnaryOperator;
import owl.ltl.Formula;
import owl.ltl.LabelledFormula;
import owl.ltl.rewriter.Fixpoint;
import owl.ltl.rewriter.PullUpXVisitor;
import owl.ltl.rewriter.PushDownXVisitor;
import owl.ltl.rewriter.SyntacticFairnessSimplifier;
import owl.ltl.rewriter.SyntacticSimplifier;

public final class SimplifierFactory {
    private static final UnaryOperator<Formula> nnfLight = x -> x.substitute(Formula::nnf);

    private SimplifierFactory() {
    }

    public static Formula apply(Formula formula, Mode mode) {
        return mode.operation.apply(formula);
    }

    public static Formula apply(Formula formula, Mode ... modes) {
        Formula result = formula;
        for (Mode mode : modes) {
            result = SimplifierFactory.apply(result, mode);
        }
        return result;
    }

    public static LabelledFormula apply(LabelledFormula formula, Mode mode) {
        return formula.wrap(SimplifierFactory.apply(formula.formula(), mode));
    }

    public static LabelledFormula apply(LabelledFormula formula, Mode ... modes) {
        return formula.wrap(SimplifierFactory.apply(formula.formula(), modes));
    }

    public static enum Mode {
        SYNTACTIC(nnfLight.andThen(SyntacticSimplifier.INSTANCE)),
        SYNTACTIC_FAIRNESS(nnfLight.andThen(SyntacticFairnessSimplifier.NormaliseX.INSTANCE).andThen(SyntacticFairnessSimplifier.INSTANCE)),
        SYNTACTIC_FIXPOINT(nnfLight.andThen(new Fixpoint(SyntacticSimplifier.INSTANCE, PullUpXVisitor.OPERATOR))),
        PULL_UP_X(PullUpXVisitor.OPERATOR),
        PUSH_DOWN_X(PushDownXVisitor.OPERATOR),
        NNF(Formula::nnf),
        NNF_LIGHT(nnfLight);

        private final Function<Formula, Formula> operation;

        private Mode(Function<Formula, Formula> operation) {
            this.operation = operation;
        }
    }
}

