/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.algorithms;

import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;
import owl.automaton.Automaton;
import owl.automaton.AutomatonUtil;
import owl.automaton.SuccessorFunction;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.GeneralizedRabinAcceptance;
import owl.automaton.acceptance.NoneAcceptance;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.acceptance.RabinAcceptance;
import owl.automaton.algorithms.SccDecomposition;
import owl.automaton.edge.Edge;

public final class LanguageEmptiness {
    private LanguageEmptiness() {
    }

    public static <S> boolean isEmpty(Automaton<S, ?> automaton) {
        return automaton.initialStates().stream().allMatch(state -> LanguageEmptiness.isEmpty(automaton, state));
    }

    private static <S> boolean dfs1(Automaton<S, ?> automaton, S q, Set<S> visitedStates, Set<S> visitedAcceptingStates, int infIndex, int finIndex, boolean acceptingState, boolean allFinIndicesBelow) {
        if (acceptingState) {
            visitedAcceptingStates.add(q);
        } else {
            visitedStates.add(q);
        }
        for (Edge<S> edge : automaton.edges(q)) {
            S successor = edge.successor();
            if (!((infIndex == -1 || edge.inSet(infIndex)) && !LanguageEmptiness.inSet(edge, finIndex, allFinIndicesBelow) ? !visitedAcceptingStates.contains(successor) && LanguageEmptiness.dfs1(automaton, successor, visitedStates, visitedAcceptingStates, infIndex, finIndex, true, allFinIndicesBelow) : !visitedStates.contains(successor) && LanguageEmptiness.dfs1(automaton, successor, visitedStates, visitedAcceptingStates, infIndex, finIndex, false, allFinIndicesBelow))) continue;
            return true;
        }
        return acceptingState && LanguageEmptiness.dfs2(automaton, q, new HashSet(), infIndex, finIndex, q, allFinIndicesBelow);
    }

    private static <S> boolean dfs2(Automaton<S, ?> automaton, S q, Set<S> visitedStatesLasso, int infIndex, int finIndex, S seed, boolean allFinIndicesBelow) {
        visitedStatesLasso.add(q);
        for (Edge<S> edge : automaton.edges(q)) {
            S successor = edge.successor();
            if ((infIndex == -1 || edge.inSet(infIndex)) && !LanguageEmptiness.inSet(edge, finIndex, allFinIndicesBelow) && successor.equals(seed)) {
                return true;
            }
            if (visitedStatesLasso.contains(successor) || LanguageEmptiness.inSet(edge, finIndex, allFinIndicesBelow) || !LanguageEmptiness.dfs2(automaton, successor, visitedStatesLasso, infIndex, finIndex, seed, allFinIndicesBelow)) continue;
            return true;
        }
        return false;
    }

    private static <S> boolean hasAcceptingLasso(Automaton<S, ?> automaton, S initialState, int infIndex, int finIndex, boolean allFinIndicesBelow) {
        HashSet visitedStates = new HashSet();
        HashSet visitedAcceptingStates = new HashSet();
        for (Edge<S> edge : automaton.edges(initialState)) {
            S successor = edge.successor();
            if (!((infIndex == -1 || edge.inSet(infIndex)) && !LanguageEmptiness.inSet(edge, finIndex, allFinIndicesBelow) ? !visitedAcceptingStates.contains(successor) && LanguageEmptiness.dfs1(automaton, successor, visitedStates, visitedAcceptingStates, infIndex, finIndex, true, allFinIndicesBelow) : !visitedStates.contains(successor) && LanguageEmptiness.dfs1(automaton, successor, visitedStates, visitedAcceptingStates, infIndex, finIndex, false, allFinIndicesBelow))) continue;
            return true;
        }
        return false;
    }

    private static <S> boolean inSet(Edge<S> edge, int index, boolean allIndicesBelow) {
        if (allIndicesBelow) {
            return edge.smallestAcceptanceSet() <= index;
        }
        return index >= 0 && edge.inSet(index);
    }

    public static <S> boolean isEmpty(Automaton<S, ?> automaton, S initialState) {
        Object acceptance = automaton.acceptance();
        assert (((OmegaAcceptance)acceptance).isWellFormedAutomaton(automaton)) : "Automaton is not well-formed.";
        if (acceptance instanceof AllAcceptance) {
            return !LanguageEmptiness.hasAcceptingLasso(automaton, initialState, -1, -1, false);
        }
        if (acceptance instanceof BuchiAcceptance) {
            Automaton<S, BuchiAcceptance> casted = AutomatonUtil.cast(automaton, BuchiAcceptance.class);
            return !Buchi.containsAcceptingLasso(casted, initialState);
        }
        if (acceptance instanceof GeneralizedBuchiAcceptance) {
            Automaton<S, GeneralizedBuchiAcceptance> casted = AutomatonUtil.cast(automaton, GeneralizedBuchiAcceptance.class);
            return !Buchi.containsAcceptingScc(casted, initialState);
        }
        if (acceptance instanceof NoneAcceptance) {
            return true;
        }
        if (acceptance instanceof ParityAcceptance) {
            Automaton<S, ParityAcceptance> casted = AutomatonUtil.cast(automaton, ParityAcceptance.class);
            return !Parity.containsAcceptingLasso(casted, initialState);
        }
        if (acceptance instanceof RabinAcceptance) {
            Automaton<S, RabinAcceptance> casted = AutomatonUtil.cast(automaton, RabinAcceptance.class);
            return !Rabin.containsAcceptingLasso(casted, initialState);
        }
        if (acceptance instanceof GeneralizedRabinAcceptance) {
            Automaton<S, GeneralizedRabinAcceptance> casted = AutomatonUtil.cast(automaton, GeneralizedRabinAcceptance.class);
            return !Rabin.containsAcceptingScc(casted, initialState);
        }
        throw new UnsupportedOperationException(String.format("Emptiness check for %s not yet implemented.", acceptance.getClass()));
    }

    private static final class Rabin {
        private Rabin() {
        }

        private static <S> boolean containsAcceptingLasso(Automaton<S, RabinAcceptance> automaton, S initialState) {
            for (GeneralizedRabinAcceptance.RabinPair pair : automaton.acceptance().pairs()) {
                if (!LanguageEmptiness.hasAcceptingLasso(automaton, initialState, pair.infSet(), pair.finSet(), false)) continue;
                return true;
            }
            return false;
        }

        private static <S> boolean containsAcceptingScc(Automaton<S, ? extends GeneralizedRabinAcceptance> automaton, S initialState) {
            for (Set<Object> scc : SccDecomposition.computeSccs(automaton::successors, initialState)) {
                for (GeneralizedRabinAcceptance.RabinPair pair : automaton.acceptance().pairs()) {
                    SuccessorFunction<Object> successorFunction = SuccessorFunction.filter(automaton, scc, edge -> !edge.inSet(pair.finSet()));
                    if (!SccDecomposition.computeSccs(successorFunction, scc).stream().anyMatch(subScc -> {
                        BitSet awaitedIndices = new BitSet();
                        pair.forEachInfSet(awaitedIndices::set);
                        for (Object state : subScc) {
                            for (Edge edge : automaton.edges(state)) {
                                if (!subScc.contains(edge.successor()) || edge.inSet(pair.finSet())) continue;
                                edge.acceptanceSetIterator().forEachRemaining(awaitedIndices::clear);
                                if (!awaitedIndices.isEmpty()) continue;
                                return true;
                            }
                        }
                        return false;
                    })) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static final class Parity {
        private Parity() {
        }

        private static <S> boolean containsAcceptingLasso(Automaton<S, ParityAcceptance> automaton, S initialState) {
            if (automaton.acceptance().parity().max()) {
                throw new UnsupportedOperationException("Only min-{even,odd} conditions supported.");
            }
            int sets = automaton.acceptance().acceptanceSets();
            if (automaton.acceptance().parity().even()) {
                for (int inf = 0; inf < sets; inf += 2) {
                    int fin = inf - 1;
                    if (LanguageEmptiness.hasAcceptingLasso(automaton, initialState, inf, fin, true)) {
                        return true;
                    }
                    if (sets - inf != 2 || !LanguageEmptiness.hasAcceptingLasso(automaton, initialState, -1, fin + 2, true)) continue;
                    return true;
                }
            } else {
                for (int fin = 0; fin < sets; fin += 2) {
                    int inf = -1;
                    if (sets - fin >= 2) {
                        inf = fin + 1;
                    }
                    if (!LanguageEmptiness.hasAcceptingLasso(automaton, initialState, inf, fin, true)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static final class Buchi {
        private Buchi() {
        }

        private static <S> boolean containsAcceptingLasso(Automaton<S, BuchiAcceptance> automaton, S initialState) {
            return LanguageEmptiness.hasAcceptingLasso(automaton, initialState, 0, -1, false);
        }

        private static <S> boolean containsAcceptingScc(Automaton<S, ? extends GeneralizedBuchiAcceptance> automaton, S initialState) {
            for (Set<Object> scc : SccDecomposition.computeSccs(automaton::successors, initialState)) {
                BitSet remaining = new BitSet(automaton.acceptance().size);
                remaining.set(0, automaton.acceptance().size);
                for (Object state : scc) {
                    for (Edge<Object> successorEdge : automaton.edges(state)) {
                        if (!scc.contains(successorEdge.successor())) continue;
                        successorEdge.acceptanceSetIterator().forEachRemaining(remaining::clear);
                        if (!remaining.isEmpty()) continue;
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

