/*
 * Decompiled with CFR 0.152.
 */
package jhoafparser.consumer;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import jhoafparser.ast.AtomAcceptance;
import jhoafparser.ast.AtomLabel;
import jhoafparser.ast.BooleanExpression;
import jhoafparser.consumer.HOAConsumer;
import jhoafparser.consumer.HOAConsumerException;
import jhoafparser.consumer.HOAConsumerFactory;

public class HOAConsumerPrint
implements HOAConsumer {
    protected Writer out;

    public HOAConsumerPrint(OutputStream out) {
        this(new OutputStreamWriter(out));
    }

    public HOAConsumerPrint(Writer out) {
        this.out = new BufferedWriter(out);
    }

    public static HOAConsumerFactory getFactory(final OutputStream stream) {
        return new HOAConsumerFactory(){

            @Override
            public HOAConsumer getNewHOAConsumer() {
                return new HOAConsumerPrint(stream);
            }
        };
    }

    @Override
    public boolean parserResolvesAliases() {
        return false;
    }

    @Override
    public void notifyHeaderStart(String version) {
        try {
            this.out.write("HOA: " + version + "\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void setNumberOfStates(int numberOfStates) {
        try {
            this.out.write("States: " + numberOfStates + "\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void addStartStates(List<Integer> stateConjunction) {
        try {
            this.out.write("Start: ");
            boolean first = true;
            for (Integer state : stateConjunction) {
                if (!first) {
                    this.out.write(" & ");
                }
                first = false;
                this.out.write(state.toString());
            }
            this.out.write("\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void addAlias(String name, BooleanExpression<AtomLabel> labelExpr) {
        try {
            this.out.write("Alias: @" + name + " " + labelExpr.toString() + "\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void setAPs(List<String> aps) {
        try {
            this.out.write("AP: ");
            this.out.write(Integer.toString(aps.size()));
            for (String ap : aps) {
                this.out.write(" ");
                this.out.write(this.quoteString(ap));
            }
            this.out.write("\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void setAcceptanceCondition(int numberOfSets, BooleanExpression<AtomAcceptance> accExpr) {
        try {
            this.out.write("Acceptance: ");
            this.out.write(Integer.toString(numberOfSets));
            this.out.write(" ");
            this.out.write(accExpr.toString());
            this.out.write("\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void provideAcceptanceName(String name, List<Object> extraInfo) {
        try {
            this.out.write("acc-name: ");
            this.out.write(name);
            for (Object info : extraInfo) {
                this.out.write(" ");
                this.out.write(info.toString());
            }
            this.out.write("\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void setName(String name) {
        try {
            this.out.write("name: ");
            this.out.write(this.quoteString(name));
            this.out.write("\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void setTool(String name, String version) {
        try {
            this.out.write("tool: ");
            this.out.write(this.quoteString(name));
            if (version != null) {
                this.out.write(" " + this.quoteString(version));
            }
            this.out.write("\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void addProperties(List<String> properties) {
        try {
            this.out.write("properties: ");
            for (String property : properties) {
                this.out.write(property);
                this.out.write(" ");
            }
            this.out.write("\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void addMiscHeader(String name, List<Object> content) {
        try {
            this.out.write(name + ": ");
            for (Object c : content) {
                this.out.write(c.toString());
                this.out.write(" ");
            }
            this.out.write("\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void notifyBodyStart() {
        try {
            this.out.write("--BODY--\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void addState(int id, String info, BooleanExpression<AtomLabel> labelExpr, List<Integer> accSignature) {
        try {
            this.out.write("State: ");
            if (labelExpr != null) {
                this.out.write("[" + labelExpr.toString() + "] ");
            }
            this.out.write(Integer.toString(id));
            if (info != null) {
                this.out.write(" ");
                this.out.write(this.quoteString(info));
            }
            if (accSignature != null) {
                this.out.write(" {");
                boolean first = true;
                for (Integer acc : accSignature) {
                    if (!first) {
                        this.out.write(" ");
                    }
                    first = false;
                    this.out.write(acc.toString());
                }
                this.out.write("}");
            }
            this.out.write("\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void addEdgeImplicit(int stateId, List<Integer> conjSuccessors, List<Integer> accSignature) {
        try {
            boolean first = true;
            for (Integer succ : conjSuccessors) {
                if (!first) {
                    this.out.write("&");
                }
                first = false;
                this.out.write(succ.toString());
            }
            if (accSignature != null) {
                this.out.write(" {");
                first = true;
                for (Integer acc : accSignature) {
                    if (!first) {
                        this.out.write(" ");
                    }
                    first = false;
                    this.out.write(acc.toString());
                }
                this.out.write("}");
            }
            this.out.write("\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void addEdgeWithLabel(int stateId, BooleanExpression<AtomLabel> labelExpr, List<Integer> conjSuccessors, List<Integer> accSignature) {
        try {
            if (labelExpr != null) {
                this.out.write("[");
                this.out.write(labelExpr.toString());
                this.out.write("] ");
            }
            boolean first = true;
            for (Integer succ : conjSuccessors) {
                if (!first) {
                    this.out.write("&");
                }
                first = false;
                this.out.write(succ.toString());
            }
            if (accSignature != null) {
                this.out.write(" {");
                first = true;
                for (Integer acc : accSignature) {
                    if (!first) {
                        this.out.write(" ");
                    }
                    first = false;
                    this.out.write(acc.toString());
                }
                this.out.write("}");
            }
            this.out.write("\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void notifyEndOfState(int stateId) throws HOAConsumerException {
    }

    @Override
    public void notifyEnd() {
        try {
            this.out.write("--END--\n");
            this.out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void notifyAbort() {
        try {
            this.out.write("--ABORT--\n");
            this.out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected String quoteString(String s) {
        String result = s.replaceAll("\\\\", "\\\\");
        result = result.replaceAll("\"", "\\\"");
        return "\"" + s + "\"";
    }

    @Override
    public void notifyWarning(String warning) throws HOAConsumerException {
        System.err.println("Warning: " + warning);
    }
}

