/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.transformations;

import com.google.common.base.Preconditions;
import java.util.BitSet;
import org.immutables.value.Value;
import owl.automaton.Automaton;
import owl.automaton.AutomatonFactory;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.edge.Edge;
import owl.automaton.transformations.DegeneralizedBuchiStateTuple;
import owl.automaton.util.AnnotatedState;
import owl.util.annotation.Tuple;

public final class BuchiDegeneralization {
    private BuchiDegeneralization() {
    }

    public static <S> Automaton<? extends AnnotatedState<S>, BuchiAcceptance> degeneralize(Automaton<S, ? extends GeneralizedBuchiAcceptance> automaton) {
        Preconditions.checkArgument((boolean)automaton.is(Automaton.Property.DETERMINISTIC));
        int sets = automaton.acceptance().acceptanceSets();
        DegeneralizedBuchiState<S> initialState = DegeneralizedBuchiState.of(automaton.onlyInitialState());
        return AutomatonFactory.create(automaton.factory(), initialState, BuchiAcceptance.INSTANCE, (state, valuation) -> {
            Edge edge = automaton.edge(state.state(), (BitSet)valuation);
            if (edge == null) {
                return null;
            }
            int nextSet = state.set();
            if (edge.inSet(nextSet)) {
                ++nextSet;
            }
            if (nextSet == sets) {
                return Edge.of(DegeneralizedBuchiState.of(edge.successor()), 0);
            }
            return Edge.of(DegeneralizedBuchiState.of(edge.successor(), nextSet));
        });
    }

    @Value.Immutable
    @Tuple
    static abstract class DegeneralizedBuchiState<S>
    implements AnnotatedState<S> {
        DegeneralizedBuchiState() {
        }

        @Override
        public abstract S state();

        abstract int set();

        public static <S> DegeneralizedBuchiState<S> of(S state) {
            return DegeneralizedBuchiState.of(state, 0);
        }

        public static <S> DegeneralizedBuchiState<S> of(S state, int set) {
            return DegeneralizedBuchiStateTuple.create(state, set);
        }
    }
}

