/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.hoa;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import jhoafparser.ast.Atom;
import jhoafparser.ast.AtomLabel;
import jhoafparser.ast.BooleanExpression;
import jhoafparser.consumer.HOAConsumer;
import jhoafparser.consumer.HOAConsumerException;
import jhoafparser.consumer.HOAConsumerPrint;
import jhoafparser.extensions.BooleanExpressions;
import owl.automaton.Automaton;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.edge.Edge;
import owl.collections.ValuationSet;
import owl.util.OwlVersion;

public final class HoaWriter {
    private HoaWriter() {
    }

    public static <S> String toString(Automaton<S, ?> automaton) {
        return HoaWriter.toString(automaton, EnumSet.of(HoaOption.ANNOTATIONS));
    }

    public static <S> String toString(Automaton<S, ?> automaton, EnumSet<HoaOption> options) {
        ByteArrayOutputStream writer = new ByteArrayOutputStream();
        HoaWriter.write(automaton, (HOAConsumer)new HOAConsumerPrint((OutputStream)writer), options);
        return new String(writer.toByteArray(), StandardCharsets.UTF_8);
    }

    public static <S> void write(Automaton<S, ?> automaton, HOAConsumer consumer) {
        HoaWriter.write(automaton, consumer, EnumSet.noneOf(HoaOption.class));
    }

    public static <S> void write(Automaton<S, ?> automaton, HOAConsumer consumer, EnumSet<HoaOption> options) {
        Wrapper<S> hoa = new Wrapper<S>(consumer, automaton.factory().atomicPropositions(), (OmegaAcceptance)automaton.acceptance(), automaton.initialStates(), options, automaton.is(Automaton.Property.DETERMINISTIC), automaton.name());
        automaton.accept((Automaton.Visitor<S>)hoa.visitor);
        hoa.done();
    }

    static final class Wrapper<S> {
        private static final Logger log = Logger.getLogger(Wrapper.class.getName());
        private final int alphabetSize;
        private final HOAConsumer consumer;
        private final EnumSet<HoaOption> options;
        private final Object2IntMap<S> stateNumbers;
        @Nullable
        private S currentState;
        final Visitor visitor = new Visitor();

        Wrapper(HOAConsumer consumer, List<String> aliases, OmegaAcceptance acceptance, Set<S> initialStates, EnumSet<HoaOption> options, boolean isDeterministic, String name) {
            this.consumer = consumer;
            this.options = EnumSet.copyOf(options);
            this.stateNumbers = new Object2IntOpenHashMap();
            this.alphabetSize = aliases.size();
            try {
                consumer.notifyHeaderStart("v1");
                OwlVersion.NameAndVersion nameAndVersion = OwlVersion.getNameAndVersion();
                consumer.setTool(nameAndVersion.name(), nameAndVersion.version());
                if (options.contains((Object)HoaOption.ANNOTATIONS)) {
                    consumer.setName(name);
                }
                for (S state : initialStates) {
                    consumer.addStartStates(List.of(Integer.valueOf(this.getStateId(state))));
                }
                String accName = acceptance.name();
                if (accName != null) {
                    consumer.provideAcceptanceName(accName, acceptance.nameExtra());
                }
                consumer.setAcceptanceCondition(acceptance.acceptanceSets(), acceptance.booleanExpression());
                if (!initialStates.isEmpty() && isDeterministic) {
                    consumer.addProperties(List.of("deterministic"));
                }
                consumer.addProperties(List.of("trans-acc", "trans-label"));
                consumer.setAPs(aliases);
                consumer.notifyBodyStart();
            }
            catch (HOAConsumerException ex) {
                log.log(Level.SEVERE, "HOAConsumer could not perform API call: ", ex);
            }
        }

        private void addEdgeBackend(BooleanExpression<AtomLabel> label, S end, IntList accSets) {
            try {
                this.consumer.addEdgeWithLabel(this.getStateId(this.currentState), label, List.of(Integer.valueOf(this.getStateId(end))), (List)(accSets.isEmpty() ? null : accSets));
            }
            catch (HOAConsumerException ex) {
                log.log(Level.SEVERE, "HOAConsumer could not perform API call: ", ex);
            }
        }

        private int getStateId(@Nullable S state) {
            Preconditions.checkState((state != null ? 1 : 0) != 0);
            return this.stateNumbers.computeIntIfAbsent(state, k -> this.stateNumbers.size());
        }

        void done() {
            try {
                this.consumer.notifyEnd();
            }
            catch (HOAConsumerException ex) {
                log.log(Level.SEVERE, "HOAConsumer could not perform API call: ", ex);
            }
        }

        class Visitor
        implements Automaton.EdgeVisitor<S>,
        Automaton.EdgeMapVisitor<S> {
            Visitor() {
            }

            @Override
            public void enter(S state) {
                Wrapper.this.currentState = state;
                String label = Wrapper.this.options.contains((Object)HoaOption.ANNOTATIONS) ? state.toString() : null;
                try {
                    Wrapper.this.consumer.addState(Wrapper.this.getStateId(state), label, null, null);
                }
                catch (HOAConsumerException ex) {
                    log.log(Level.SEVERE, "HOAConsumer could not perform API call: ", ex);
                }
            }

            @Override
            public void exit(S state) {
                Preconditions.checkState((boolean)state.equals(Wrapper.this.currentState));
                try {
                    Wrapper.this.consumer.notifyEndOfState(Wrapper.this.getStateId(Wrapper.this.currentState));
                }
                catch (HOAConsumerException ex) {
                    log.log(Level.SEVERE, "HOAConsumer could not perform API call: ", ex);
                }
            }

            @Override
            public void visit(S state, BitSet valuation, Edge<S> edge) {
                IntArrayList accSets = new IntArrayList();
                edge.acceptanceSetIterator().forEachRemaining(arg_0 -> ((IntArrayList)accSets).add(arg_0));
                ArrayList conjuncts = new ArrayList(Wrapper.this.alphabetSize);
                for (int i = 0; i < Wrapper.this.alphabetSize; ++i) {
                    BooleanExpression atom = new BooleanExpression((Atom)AtomLabel.createAPIndex((Integer)i));
                    if (valuation.get(i)) {
                        conjuncts.add(atom);
                        continue;
                    }
                    conjuncts.add(atom.not());
                }
                Wrapper.this.addEdgeBackend(BooleanExpressions.createConjunction(conjuncts), edge.successor(), (IntList)accSets);
            }

            @Override
            public void visit(S state, Map<Edge<S>, ValuationSet> edgeMap) {
                edgeMap.forEach((edge, valuationSet) -> {
                    Object end = edge.successor();
                    if (valuationSet.isEmpty()) {
                        return;
                    }
                    IntArrayList acceptanceSets = new IntArrayList();
                    edge.forEachAcceptanceSet(arg_0 -> ((IntArrayList)acceptanceSets).add(arg_0));
                    Wrapper.this.addEdgeBackend(valuationSet.toExpression(), end, (IntList)acceptanceSets);
                });
            }
        }
    }

    public static enum HoaOption {
        ANNOTATIONS;

    }
}

