/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.set;

import de.tum.in.naturals.bitset.RoaringBitmaps;
import de.tum.in.naturals.set.AbstractNatBitSet;
import de.tum.in.naturals.set.MutableSingletonNatBitSet;
import de.tum.in.naturals.set.RoaringBoundedNatBitSet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.Collection;
import java.util.Set;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import org.roaringbitmap.RoaringBitmap;

class RoaringNatBitSet
extends AbstractNatBitSet {
    private static final long INFINITY = 0x80000000L;
    private final RoaringBitmap bitmap;

    RoaringNatBitSet(RoaringBitmap bitmap) {
        this.bitmap = bitmap;
    }

    public boolean isEmpty() {
        return this.bitmap.isEmpty();
    }

    public int size() {
        return this.bitmap.getCardinality();
    }

    public boolean contains(int index) {
        return 0 <= index && this.bitmap.contains(index);
    }

    public boolean containsAll(IntCollection indices) {
        if (this.isEmpty()) {
            return indices.isEmpty();
        }
        if (indices.isEmpty()) {
            return true;
        }
        if (indices instanceof RoaringNatBitSet) {
            RoaringNatBitSet other = (RoaringNatBitSet)indices;
            return this.bitmap.contains(other.bitmap);
        }
        if (indices instanceof RoaringBoundedNatBitSet) {
            RoaringBoundedNatBitSet other = (RoaringBoundedNatBitSet)indices;
            if (other.isComplement()) {
                return this.bitmap.rank(other.domainSize() - 1) + other.bitmap().getCardinality() == other.domainSize() + RoaringBitmap.andCardinality((RoaringBitmap)this.bitmap, (RoaringBitmap)other.bitmap());
            }
            return this.bitmap.contains(other.bitmap());
        }
        return super.containsAll(indices);
    }

    @Override
    public int firstInt() {
        return this.bitmap.first();
    }

    @Override
    public int lastInt() {
        return this.bitmap.last();
    }

    @Override
    public int nextPresentIndex(int index) {
        return Math.toIntExact(this.bitmap.nextValue(index));
    }

    @Override
    public int nextAbsentIndex(int index) {
        return Math.toIntExact(this.bitmap.nextAbsentValue(index));
    }

    @Override
    public int previousPresentIndex(int index) {
        return Math.toIntExact(this.bitmap.previousValue(index));
    }

    @Override
    public int previousAbsentIndex(int index) {
        return Math.toIntExact(this.bitmap.previousAbsentValue(index));
    }

    @Override
    public IntIterator iterator() {
        return RoaringBitmaps.iterator(this.bitmap);
    }

    public void forEach(IntConsumer consumer) {
        this.bitmap.forEach(consumer::accept);
    }

    @Override
    public void set(int index) {
        this.bitmap.add(index);
    }

    @Override
    public void set(int index, boolean value) {
        if (value) {
            this.bitmap.add(index);
        } else {
            this.bitmap.remove(index);
        }
    }

    @Override
    public void set(int from, int to) {
        this.bitmap.add((long)from, (long)to);
    }

    public void clear() {
        this.bitmap.clear();
    }

    @Override
    public void clear(int index) {
        this.bitmap.remove(index);
    }

    @Override
    public void clear(int from, int to) {
        this.bitmap.remove((long)from, (long)to);
    }

    @Override
    public void clearFrom(int from) {
        this.bitmap.remove((long)from, 0x80000000L);
    }

    @Override
    public void flip(int index) {
        this.bitmap.flip(index);
    }

    @Override
    public void flip(int from, int to) {
        this.bitmap.flip((long)from, (long)to);
    }

    @Override
    public boolean intersects(Collection<Integer> indices) {
        if (indices instanceof RoaringNatBitSet) {
            RoaringNatBitSet other = (RoaringNatBitSet)((Object)indices);
            return RoaringBitmap.intersects((RoaringBitmap)this.bitmap, (RoaringBitmap)other.bitmap);
        }
        if (indices instanceof RoaringBoundedNatBitSet) {
            RoaringBoundedNatBitSet other = (RoaringBoundedNatBitSet)((Object)indices);
            return other.isComplement() ? RoaringBitmap.intersects((RoaringBitmap)this.bitmap, (RoaringBitmap)other.complementBits()) : RoaringBitmap.intersects((RoaringBitmap)this.bitmap, (RoaringBitmap)other.bitmap());
        }
        return super.intersects(indices);
    }

    @Override
    public void and(IntCollection indices) {
        if (indices.isEmpty()) {
            this.clear();
        } else if (indices instanceof RoaringNatBitSet) {
            RoaringNatBitSet other = (RoaringNatBitSet)indices;
            this.bitmap.and(other.bitmap);
        } else if (indices instanceof RoaringBoundedNatBitSet) {
            RoaringBoundedNatBitSet other = (RoaringBoundedNatBitSet)indices;
            this.bitmap.remove((long)other.domainSize(), 0x80000000L);
            if (other.isComplement()) {
                this.bitmap.andNot(other.bitmap());
            } else {
                this.bitmap.and(other.bitmap());
            }
        } else if (indices instanceof MutableSingletonNatBitSet) {
            MutableSingletonNatBitSet singleton = (MutableSingletonNatBitSet)indices;
            int index = singleton.firstInt();
            assert (index == singleton.lastInt());
            boolean contains = this.contains(index);
            this.clear();
            if (contains) {
                this.set(index);
            }
        } else {
            this.bitmap.and(RoaringBitmaps.of((IntIterable)indices));
        }
    }

    @Override
    public void andNot(IntCollection indices) {
        if (this.isEmpty() || indices.isEmpty()) {
            return;
        }
        if (indices instanceof RoaringNatBitSet) {
            RoaringNatBitSet other = (RoaringNatBitSet)indices;
            this.bitmap.andNot(other.bitmap);
        } else if (indices instanceof RoaringBoundedNatBitSet) {
            RoaringBoundedNatBitSet other = (RoaringBoundedNatBitSet)indices;
            int otherDomainSize = other.domainSize();
            if (other.isComplement()) {
                RoaringBitmap tail = RoaringBitmaps.subset(this.bitmap, otherDomainSize, 0x80000000L);
                this.bitmap.and(other.bitmap());
                this.bitmap.or(tail);
            } else {
                this.bitmap.andNot(other.bitmap());
            }
        } else {
            this.bitmap.andNot(RoaringBitmaps.of((IntIterable)indices));
        }
    }

    @Override
    public void or(IntCollection indices) {
        if (indices.isEmpty()) {
            return;
        }
        if (indices instanceof RoaringNatBitSet) {
            RoaringNatBitSet other = (RoaringNatBitSet)indices;
            this.bitmap.or(other.bitmap);
        } else if (indices instanceof RoaringBoundedNatBitSet) {
            RoaringBoundedNatBitSet other = (RoaringBoundedNatBitSet)indices;
            if (other.isComplement()) {
                RoaringBitmap tail = RoaringBitmaps.subset(this.bitmap, other.domainSize(), 0x80000000L);
                this.bitmap.orNot(other.bitmap(), (long)other.domainSize());
                this.bitmap.or(tail);
            } else {
                this.bitmap.or(other.bitmap());
            }
        } else {
            this.bitmap.or(RoaringBitmaps.of((IntIterable)indices));
        }
    }

    @Override
    public void xor(IntCollection indices) {
        if (indices instanceof RoaringNatBitSet) {
            RoaringNatBitSet other = (RoaringNatBitSet)indices;
            this.bitmap.xor(other.bitmap);
        } else if (indices instanceof RoaringBoundedNatBitSet) {
            RoaringBoundedNatBitSet other = (RoaringBoundedNatBitSet)indices;
            this.bitmap.xor(other.bitmap());
            if (other.isComplement()) {
                this.bitmap.flip(0L, (long)other.domainSize());
            }
        } else {
            this.bitmap.xor(RoaringBitmaps.of((IntIterable)indices));
        }
    }

    public boolean removeIf(IntPredicate filter) {
        RoaringBitmap remove = new RoaringBitmap();
        this.bitmap.forEach(i -> {
            if (filter.test(i)) {
                remove.add(i);
            }
        });
        this.bitmap.andNot(remove);
        return !remove.isEmpty();
    }

    @Override
    public RoaringNatBitSet clone() {
        return new RoaringNatBitSet(this.bitmap.clone());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Set)) {
            return false;
        }
        if (this.isEmpty()) {
            return ((Collection)o).isEmpty();
        }
        if (((Collection)o).isEmpty()) {
            return false;
        }
        if (o instanceof RoaringNatBitSet) {
            RoaringNatBitSet other = (RoaringNatBitSet)o;
            return this.bitmap.equals((Object)other.bitmap);
        }
        if (o instanceof RoaringBoundedNatBitSet) {
            RoaringBoundedNatBitSet other = (RoaringBoundedNatBitSet)o;
            if (this.lastInt() >= other.domainSize()) {
                return false;
            }
            if (other.isComplement()) {
                return this.size() == other.size() && !RoaringBitmap.intersects((RoaringBitmap)this.bitmap, (RoaringBitmap)other.bitmap());
            }
            return this.bitmap.equals((Object)other.bitmap());
        }
        return super.equals(o);
    }

    RoaringBitmap bitmap() {
        return this.bitmap;
    }
}

