/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.activitydiagram3.ftile.Worm;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class WormMutation {
    private final List<UTranslate> translations = new ArrayList<UTranslate>();

    private WormMutation() {
    }

    public static WormMutation create(Worm worm, double delta) {
        String signature = worm.getDirectionsCode();
        String definition = WormMutation.getDefinition(signature);
        if (definition == null) {
            return WormMutation.createFromLongSignature(signature, delta);
        }
        return new WormMutation(definition, delta);
    }

    private static WormMutation createFromLongSignature(String signature, double delta) {
        WormMutation result = new WormMutation();
        for (int i = 0; i < signature.length() - 1; ++i) {
            WormMutation tmp = new WormMutation(WormMutation.getDefinition(signature.substring(i, i + 2)), delta);
            if (i == 0) {
                result.translations.add(tmp.translations.get(0));
            } else {
                UTranslate last = result.getLast();
                if (!last.isAlmostSame(tmp.translations.get(0))) {
                    tmp = tmp.reverse();
                }
            }
            result.translations.add(tmp.translations.get(1));
            if (i != signature.length() - 2) continue;
            result.translations.add(tmp.translations.get(2));
        }
        return result;
    }

    private WormMutation reverse() {
        WormMutation result = new WormMutation();
        for (UTranslate tr : this.translations) {
            result.translations.add(tr.reverse());
        }
        return result;
    }

    public UTranslate getLast() {
        return this.translations.get(this.translations.size() - 1);
    }

    public UTranslate getFirst() {
        return this.translations.get(0);
    }

    public int size() {
        return this.translations.size();
    }

    private static String getDefinition(String signature) {
        if (signature.equals("D") || signature.equals("U")) {
            return "33";
        }
        if (signature.equals("L") || signature.equals("R")) {
            return "55";
        }
        if (signature.equals("RD")) {
            return "123";
        }
        if (signature.equals("RU")) {
            return "543";
        }
        if (signature.equals("LD")) {
            return "187";
        }
        if (signature.equals("DL")) {
            return "345";
        }
        if (signature.equals("DR")) {
            return "765";
        }
        if (signature.equals("UL")) {
            return "321";
        }
        if (signature.equals("UR")) {
            return "781";
        }
        return null;
    }

    private WormMutation(String definition, double delta) {
        if (definition == null) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < definition.length(); ++i) {
            this.translations.add(WormMutation.translation(Integer.parseInt(definition.substring(i, i + 1)), delta));
        }
    }

    private static UTranslate translation(int type, double delta) {
        switch (type) {
            case 1: {
                return new UTranslate(0.0, -delta);
            }
            case 2: {
                return new UTranslate(delta, -delta);
            }
            case 3: {
                return new UTranslate(delta, 0.0);
            }
            case 4: {
                return new UTranslate(delta, delta);
            }
            case 5: {
                return new UTranslate(0.0, delta);
            }
            case 6: {
                return new UTranslate(-delta, delta);
            }
            case 7: {
                return new UTranslate(-delta, 0.0);
            }
            case 8: {
                return new UTranslate(-delta, -delta);
            }
        }
        throw new IllegalArgumentException();
    }

    public UTranslate getTextTranslate(int size) {
        MinMax result = new MinMax();
        for (UTranslate tr : this.translations) {
            result.append(tr.getDx());
        }
        return new UTranslate(result.getExtreme() * (double)(size - 1), 0.0);
    }

    public boolean isDxNegative() {
        return this.translations.get(0).getDx() < 0.0;
    }

    public Worm mute(Worm original) {
        Worm result = new Worm();
        for (int i = 0; i < original.size(); ++i) {
            result.addPoint(this.translations.get(i).getTranslated(original.get(i)));
        }
        return result;
    }

    private static class MinMax {
        private double min = Double.MAX_VALUE;
        private double max = Double.MIN_VALUE;

        private MinMax() {
        }

        private void append(double v) {
            if (v > this.max) {
                this.max = v;
            }
            if (v < this.min) {
                this.min = v;
            }
        }

        private double getExtreme() {
            if (Math.abs(this.max) > Math.abs(this.min)) {
                return this.max;
            }
            return this.min;
        }
    }
}

