/*
 * Decompiled with CFR 0.152.
 */
package smetana.core;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import smetana.core.JUtils;

public class OFFSET {
    private static int CPT = 10000;
    private static Map<Integer, OFFSET> byID = new HashMap<Integer, OFFSET>();
    private static Map<Object, OFFSET> primaryKey = new HashMap<Object, OFFSET>();
    private final Class cl;
    private final String field;
    private final int id;

    private OFFSET(Class cl, String field) {
        this.cl = cl;
        this.field = field;
        this.id = CPT++;
        JUtils.LOG("REAL CREATING OF " + this);
    }

    public String toString() {
        return this.cl.getName() + "::" + this.field;
    }

    public static OFFSET create(Class cl, String field) {
        List<Serializable> key = Arrays.asList(cl, field);
        JUtils.LOG("getting OFFSET " + key);
        OFFSET result = primaryKey.get(key);
        if (result != null) {
            JUtils.LOG("FOUND!");
            return result;
        }
        result = new OFFSET(cl, field);
        byID.put(result.id, result);
        primaryKey.put(key, result);
        return result;
    }

    public int toInt() {
        return this.id;
    }

    public static OFFSET fromInt(int value) {
        OFFSET result = byID.get(value);
        if (result == null) {
            throw new IllegalArgumentException("value=" + value);
        }
        return result;
    }

    public final Class getTheClass() {
        return this.cl;
    }

    public final String getField() {
        return this.field;
    }
}

