
#include "static_isa.h" // from http://oonumerics.org/tmpw00/mcnamara.html
#include "exact_type.hh"


//
//  a bound map to a struct and foo with bounded quantification
//
//////////////////////////////////////////////////////////////////////


template<class I = Bottom>
struct A : public Void< A<I> > {
  // structural_check:
  MAKE_TRAITS;
  template<class Self> static void check_structural() {
    void (Self::*_m)() const = &Self::m;
    (void)_m;
  }
protected:
  ~A() {
    RequireBoth< I, A<I> >();
    // means:
    // I is required to be a sub-class of A<I>
    // *and* structural checking is performed
  }
};


template<class T>
void foo(A<T>& a) {
  to_exact(a).m();
}



//
//  two structs: one conforms, the other does not
//
//////////////////////////////////////////////////////////////////////


template<class I = Bottom>
struct B1 : public A< B1<I> > {
  void m() {
    // ...
  }
};


struct Z {
};





//
//  main
//
//////////////////////////////////////////////////////////////////////


int main() {
  B1<> b;  foo(b);  // ok
  Z    z;  foo(z);  // error
}
