/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import com.google.common.collect.Collections2;
import de.tum.in.naturals.bitset.BitSets;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import owl.automaton.Automaton;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.edge.Edge;
import owl.automaton.edge.LabelledEdge;
import owl.automaton.edge.LabelledEdges;
import owl.collections.ValuationSet;
import owl.factories.ValuationSetFactory;

public interface EdgesAutomatonMixin<S, A extends OmegaAcceptance>
extends Automaton<S, A> {
    @Override
    default public Set<S> successors(S state) {
        return new HashSet(Collections2.transform(this.edges(state), Edge::successor));
    }

    @Override
    default public Collection<Edge<S>> edges(S state) {
        HashSet<Edge<S>> edges = new HashSet<Edge<S>>();
        for (BitSet valuation : BitSets.powerSet((int)this.factory().alphabetSize())) {
            edges.addAll(this.edges(state, valuation));
        }
        return edges;
    }

    @Override
    default public Collection<LabelledEdge<S>> labelledEdges(S state) {
        ValuationSetFactory factory = this.factory();
        HashMap labelledEdges = new HashMap();
        for (BitSet valuation : BitSets.powerSet((int)factory.alphabetSize())) {
            for (Edge<S> edge : this.edges(state, valuation)) {
                labelledEdges.merge(edge, factory.of(valuation), ValuationSet::union);
            }
        }
        return LabelledEdges.asCollection(labelledEdges);
    }

    @Override
    default public boolean prefersLabelled() {
        return false;
    }
}

