/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import owl.automaton.Automaton;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.edge.Edge;
import owl.automaton.edge.LabelledEdge;
import owl.collections.Collections3;

public interface LabelledEdgesAutomatonMixin<S, A extends OmegaAcceptance>
extends Automaton<S, A> {
    @Override
    default public Set<S> successors(S state) {
        return new HashSet(Collections2.transform(this.labelledEdges(state), LabelledEdge::successor));
    }

    @Override
    default public Collection<Edge<S>> edges(S state) {
        return new ArrayList<Edge<S>>(Collections2.transform(this.labelledEdges(state), LabelledEdge::edge));
    }

    @Override
    default public Collection<Edge<S>> edges(S state, BitSet valuation) {
        return Collections3.transformUnique(this.labelledEdges(state), x -> x.valuations.contains(valuation) ? x.edge : null);
    }

    @Override
    default public boolean prefersLabelled() {
        return true;
    }
}

