/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.edge;

import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.Map;
import owl.automaton.edge.Edge;
import owl.automaton.edge.LabelledEdge;
import owl.collections.ValuationSet;

public final class LabelledEdges {
    private LabelledEdges() {
    }

    public static <S> Collection<ValuationSet> valuations(Collection<LabelledEdge<S>> labelledEdges) {
        return Collections2.transform(labelledEdges, LabelledEdge::valuations);
    }

    public static <S> Collection<Edge<S>> edges(Collection<LabelledEdge<S>> labelledEdges) {
        return Collections2.transform(labelledEdges, LabelledEdge::edge);
    }

    public static <S> Collection<S> successors(Collection<LabelledEdge<S>> labelledEdges) {
        return Collections2.transform(labelledEdges, l -> l.edge.successor());
    }

    public static <S> Collection<LabelledEdge<S>> asCollection(Map<Edge<S>, ValuationSet> map) {
        return Collections2.transform(map.entrySet(), LabelledEdge::of);
    }
}

