/*
 * Decompiled with CFR 0.152.
 */
package owl.collections;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;

public final class Collections3 {
    private Collections3() {
    }

    public static <T> boolean addAllDistinct(List<T> list, Collection<T> elements) {
        boolean changed = false;
        for (T element : elements) {
            changed |= Collections3.addDistinct(list, element);
        }
        return changed;
    }

    public static <T> boolean addDistinct(List<T> list, T element) {
        if (list.contains(element)) {
            return false;
        }
        list.add(element);
        return true;
    }

    public static <E> boolean isDistinct(Collection<E> collection) {
        HashSet<E> set = new HashSet<E>(collection.size());
        for (E element : collection) {
            if (set.add(element)) continue;
            return false;
        }
        return true;
    }

    public static <E> Collection<E> append(final Collection<E> list, final E element) {
        if (list.isEmpty()) {
            return List.of(element);
        }
        return new AbstractCollection<E>(){

            @Override
            public boolean contains(Object o) {
                return list.contains(o) || element.equals(o);
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public Iterator<E> iterator() {
                return Iterators.concat(list.iterator(), (Iterator)Iterators.singletonIterator((Object)element));
            }

            @Override
            public int size() {
                return list.size() + 1;
            }
        };
    }

    public static <E> List<E> append(final List<E> list, final E element) {
        if (list.isEmpty()) {
            return List.of(element);
        }
        return new AbstractList<E>(){

            @Override
            public boolean contains(Object o) {
                return list.contains(o) || element.equals(o);
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public E get(int index) {
                int size = list.size();
                Objects.checkIndex(index, size + 1);
                return index == size ? element : list.get(index);
            }

            @Override
            public int size() {
                return list.size() + 1;
            }
        };
    }

    public static <F, T> Set<T> transformUnique(Collection<F> collection, Function<F, T> transformer) {
        if (collection.isEmpty()) {
            return Set.of();
        }
        int size = collection.size();
        if (size == 1) {
            T element = transformer.apply(Iterables.getOnlyElement(collection));
            return element == null ? Set.of() : Set.of(element);
        }
        HashSet<T> set = new HashSet<T>(size);
        for (F element : collection) {
            T transformed = transformer.apply(element);
            if (transformed == null) continue;
            set.add(transformed);
        }
        return set;
    }

    public static <E1, E2> void zip(Iterable<E1> iterable1, Iterable<E2> iterable2, BiConsumer<E1, E2> action) {
        Iterator<E1> iterator1 = iterable1.iterator();
        Iterator<E2> iterator2 = iterable2.iterator();
        while (iterator1.hasNext() && iterator2.hasNext()) {
            action.accept(iterator1.next(), iterator2.next());
        }
        Preconditions.checkArgument((!iterator1.hasNext() && !iterator2.hasNext() ? 1 : 0) != 0, (Object)"Length mismatch.");
    }
}

