/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import de.tum.in.naturals.bitset.BitSets;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.immutables.value.Value;
import owl.collections.Collections3;
import owl.ltl.Formula;
import owl.ltl.LabelledFormulaTuple;
import owl.ltl.visitors.BinaryVisitor;
import owl.ltl.visitors.IntVisitor;
import owl.ltl.visitors.PrintVisitor;
import owl.ltl.visitors.Visitor;
import owl.util.annotation.HashedTuple;

@Value.Immutable
@HashedTuple
public abstract class LabelledFormula {
    public abstract Formula formula();

    public abstract List<String> variables();

    public abstract Set<String> player1Variables();

    @Value.Check
    void check() {
        Preconditions.checkState((boolean)Collections3.isDistinct(this.variables()));
        Preconditions.checkState((boolean)this.variables().containsAll(this.player1Variables()));
    }

    public static LabelledFormula of(Formula formula, List<String> variables) {
        return LabelledFormulaTuple.create(formula, variables, variables);
    }

    public static LabelledFormula of(Formula formula, List<String> variables, Set<String> player1) {
        return LabelledFormulaTuple.create(formula, variables, player1);
    }

    public static LabelledFormula of(Formula formula, List<String> variables, BitSet player1) {
        HashSet player1Variables = new HashSet();
        BitSets.forEach((BitSet)player1, i -> player1Variables.add((String)variables.get(i)));
        return LabelledFormulaTuple.create(formula, variables, Set.copyOf(player1Variables));
    }

    public LabelledFormula wrap(Formula formula) {
        return LabelledFormula.of(formula, this.variables(), this.player1Variables());
    }

    public LabelledFormula split(Set<String> player1) {
        return LabelledFormula.of(this.formula(), this.variables(), player1);
    }

    public LabelledFormula not() {
        return this.wrap(this.formula().not());
    }

    Set<String> player2Variables() {
        Set<String> player1 = this.player1Variables();
        return Set.copyOf(Sets.difference(Set.copyOf(this.variables()), player1));
    }

    public int accept(IntVisitor visitor) {
        return this.formula().accept(visitor);
    }

    public <R> R accept(Visitor<R> visitor) {
        return this.formula().accept(visitor);
    }

    public <R, P> R accept(BinaryVisitor<P, R> visitor, P parameter) {
        return this.formula().accept(visitor, parameter);
    }

    public LabelledFormula convert(Visitor<Formula> visitor) {
        return this.wrap(this.formula().accept(visitor));
    }

    public boolean allMatch(Predicate<Formula> predicate) {
        return this.formula().allMatch(predicate);
    }

    public boolean anyMatch(Predicate<Formula> predicate) {
        return this.formula().anyMatch(predicate);
    }

    public String toString() {
        return PrintVisitor.toString(this, false);
    }
}

