/*
 * Decompiled with CFR 0.152.
 */
package owl.translations;

import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import java.util.BitSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import owl.automaton.Automaton;
import owl.automaton.AutomatonFactory;
import owl.automaton.AutomatonUtil;
import owl.automaton.Views;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.CoBuchiAcceptance;
import owl.automaton.edge.Edge;
import owl.automaton.edge.LabelledEdge;
import owl.automaton.ldba.LimitDeterministicAutomaton;
import owl.collections.ValuationSet;
import owl.factories.Factories;
import owl.factories.ValuationSetFactory;
import owl.ltl.EquivalenceClass;
import owl.ltl.LabelledFormula;
import owl.ltl.SyntacticFragment;
import owl.ltl.SyntacticFragments;
import owl.run.Environment;
import owl.translations.delag.DelagBuilder;
import owl.translations.ltl2dpa.LTL2DPAFunction;
import owl.translations.ltl2dra.LTL2DRAFunction;
import owl.translations.ltl2ldba.EquivalenceClassStateFactory;
import owl.translations.ltl2ldba.LTL2LDBAFunction;
import owl.translations.ltl2ldba.breakpoint.DegeneralizedBreakpointState;
import owl.translations.ltl2ldba.breakpoint.GObligations;

public final class LTL2DAFunction
implements Function<LabelledFormula, Automaton<?, ?>> {
    private final Environment environment;
    private final EnumSet<Constructions> allowedConstructions;
    @Nullable
    private final Function<LabelledFormula, ? extends Automaton<?, ?>> fallback;

    public LTL2DAFunction(Environment environment, boolean onTheFly, EnumSet<Constructions> allowedConstructions) {
        this.allowedConstructions = EnumSet.copyOf(allowedConstructions);
        this.environment = environment;
        if (this.allowedConstructions.contains((Object)Constructions.EMERSON_LEI)) {
            this.fallback = new DelagBuilder(environment);
        } else if (this.allowedConstructions.contains((Object)Constructions.RABIN)) {
            EnumSet<LTL2DRAFunction.Configuration> configuration = EnumSet.of(LTL2DRAFunction.Configuration.OPTIMISE_INITIAL_STATE, LTL2DRAFunction.Configuration.OPTIMISED_STATE_STRUCTURE, LTL2DRAFunction.Configuration.EXISTS_SAFETY_CORE);
            this.fallback = new LTL2DRAFunction(environment, configuration);
        } else if (this.allowedConstructions.contains((Object)Constructions.PARITY)) {
            EnumSet<LTL2DPAFunction.Configuration> configuration = EnumSet.copyOf(LTL2DPAFunction.RECOMMENDED_ASYMMETRIC_CONFIG);
            if (onTheFly) {
                configuration.add(LTL2DPAFunction.Configuration.GREEDY);
                configuration.remove((Object)LTL2DPAFunction.Configuration.COMPRESS_COLOURS);
                configuration.remove((Object)LTL2DPAFunction.Configuration.OPTIMISE_INITIAL_STATE);
            }
            this.fallback = new LTL2DPAFunction(environment, configuration);
        } else {
            this.fallback = null;
        }
    }

    @Override
    public Automaton<?, ?> apply(LabelledFormula formula) {
        if (this.allowedConstructions.contains((Object)Constructions.SAFETY) && SyntacticFragment.SAFETY.contains(formula)) {
            return this.safety(formula);
        }
        if (this.allowedConstructions.contains((Object)Constructions.CO_SAFETY) && SyntacticFragment.CO_SAFETY.contains(formula)) {
            return this.coSafety(formula);
        }
        if (this.allowedConstructions.contains((Object)Constructions.BUCHI) && SyntacticFragments.isDetBuchiRecognisable(formula.formula())) {
            return this.buchi(formula);
        }
        if (this.allowedConstructions.contains((Object)Constructions.CO_BUCHI) && SyntacticFragments.isDetCoBuchiRecognisable(formula.formula())) {
            return this.coBuchi(formula);
        }
        if (this.fallback == null) {
            throw new IllegalArgumentException("All allowed constructions exhausted.");
        }
        return this.fallback.apply(formula);
    }

    private Automaton<DegeneralizedBreakpointState, BuchiAcceptance> buchi(LabelledFormula formula) {
        EnumSet<LTL2LDBAFunction.Configuration> configuration = EnumSet.of(LTL2LDBAFunction.Configuration.EAGER_UNFOLD, LTL2LDBAFunction.Configuration.SUPPRESS_JUMPS, LTL2LDBAFunction.Configuration.FORCE_JUMPS, LTL2LDBAFunction.Configuration.OPTIMISED_STATE_STRUCTURE);
        Function<LabelledFormula, LimitDeterministicAutomaton<EquivalenceClass, DegeneralizedBreakpointState, BuchiAcceptance, GObligations>> builder = LTL2LDBAFunction.createDegeneralizedBreakpointLDBABuilder(this.environment, configuration);
        LimitDeterministicAutomaton<EquivalenceClass, DegeneralizedBreakpointState, BuchiAcceptance, GObligations> ldba = builder.apply(formula);
        Automaton<DegeneralizedBreakpointState, BuchiAcceptance> acceptingComponent = ldba.acceptingComponent();
        assert (ldba.isDeterministic());
        if (acceptingComponent.initialStates().isEmpty()) {
            ValuationSetFactory vsFactory = this.environment.factorySupplier().getValuationSetFactory(formula.variables());
            return AutomatonFactory.singleton(vsFactory, DegeneralizedBreakpointState.createSink(), BuchiAcceptance.INSTANCE);
        }
        return ldba.acceptingComponent();
    }

    private Automaton<DegeneralizedBreakpointState, CoBuchiAcceptance> coBuchi(LabelledFormula formula) {
        return AutomatonUtil.cast(Views.complement(this.buchi(formula.not()), DegeneralizedBreakpointState.createSink()), CoBuchiAcceptance.class);
    }

    private Automaton<EquivalenceClass, BuchiAcceptance> coSafety(LabelledFormula formula) {
        Preconditions.checkArgument((boolean)SyntacticFragment.CO_SAFETY.contains(formula.formula()), (Object)"Formula is not from the syntactic co-safety fragment.");
        Factories factories = this.environment.factorySupplier().getFactories(formula.variables(), false);
        EquivalenceClassStateFactory factory = new EquivalenceClassStateFactory(factories, true, false);
        BiFunction<EquivalenceClass, BitSet, Set> single = (x, y) -> {
            EquivalenceClass successor = factory.getSuccessor((EquivalenceClass)x, (BitSet)y, new EquivalenceClass[0]);
            if (successor.isFalse()) {
                return Set.of();
            }
            if (successor.isTrue()) {
                return Set.of(Edge.of(successor, 0));
            }
            return Set.of(Edge.of(successor));
        };
        Function<EquivalenceClass, Collection> bulk = x -> {
            Set<Map.Entry<EquivalenceClass, ValuationSet>> successors = factory.getSuccessors((EquivalenceClass)x).entrySet();
            return Collections2.transform(successors, y -> {
                EquivalenceClass successor = (EquivalenceClass)y.getKey();
                if (successor.isTrue()) {
                    return LabelledEdge.of(successor, 0, (ValuationSet)y.getValue());
                }
                return LabelledEdge.of(successor, (ValuationSet)y.getValue());
            });
        };
        return AutomatonFactory.create(factories.vsFactory, factory.getInitial(formula.formula()), BuchiAcceptance.INSTANCE, single, bulk);
    }

    private Automaton<EquivalenceClass, AllAcceptance> safety(LabelledFormula formula) {
        Preconditions.checkArgument((boolean)SyntacticFragment.SAFETY.contains(formula.formula()), (Object)"Formula is not from the syntactic safety fragment.");
        Factories factories = this.environment.factorySupplier().getFactories(formula.variables(), false);
        EquivalenceClassStateFactory factory = new EquivalenceClassStateFactory(factories, true, false);
        BiFunction<EquivalenceClass, BitSet, Set> single = (x, y) -> {
            EquivalenceClass successor = factory.getSuccessor((EquivalenceClass)x, (BitSet)y, new EquivalenceClass[0]);
            return successor.isFalse() ? Set.of() : Set.of(Edge.of(successor));
        };
        Function<EquivalenceClass, Collection> bulk = x -> {
            Set<Map.Entry<EquivalenceClass, ValuationSet>> successors = factory.getSuccessors((EquivalenceClass)x).entrySet();
            return Collections2.transform(successors, y -> LabelledEdge.of((EquivalenceClass)y.getKey(), (ValuationSet)y.getValue()));
        };
        return AutomatonFactory.create(factories.vsFactory, factory.getInitial(formula.formula()), AllAcceptance.INSTANCE, single, bulk);
    }

    public static enum Constructions {
        SAFETY,
        CO_SAFETY,
        BUCHI,
        CO_BUCHI,
        EMERSON_LEI,
        RABIN,
        PARITY;

    }
}

