/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.rabinizer;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import owl.ltl.LabelledFormula;
import owl.run.modules.OwlModuleParser;
import owl.run.modules.Transformer;
import owl.run.modules.Transformers;
import owl.translations.rabinizer.ImmutableRabinizerConfiguration;
import owl.translations.rabinizer.RabinizerBuilder;

public final class RabinizerCliParser
implements OwlModuleParser.TransformerParser {
    public static final RabinizerCliParser INSTANCE = new RabinizerCliParser();

    private RabinizerCliParser() {
    }

    @Override
    public String getKey() {
        return "ltl2dgra";
    }

    @Override
    public String getDescription() {
        return "Translates LTL to deterministic generalized Rabin automata, using the Rabinizer construction";
    }

    @Override
    public Options getOptions() {
        return new Options().addOption("ne", "noeager", false, "Disable eager construction").addOption("np", "nosuspend", false, "Disable suspension detection").addOption("ns", "nosupport", false, "Disable support based relevant formula analysis").addOption("na", "noacceptance", false, "Disable generation of acceptance condition").addOption("c", "complete", false, "Build complete automaton");
    }

    @Override
    public Transformer parse(CommandLine commandLine) {
        boolean eager = !commandLine.hasOption("noeager");
        boolean support = !commandLine.hasOption("nosupport");
        boolean acceptance = !commandLine.hasOption("noacceptance");
        boolean complete = commandLine.hasOption("complete");
        boolean suspend = !commandLine.hasOption("nosuspend");
        ImmutableRabinizerConfiguration configuration = ImmutableRabinizerConfiguration.builder().eager(eager).supportBasedRelevantFormulaAnalysis(support).computeAcceptance(acceptance).completeAutomaton(complete).suspendableFormulaDetection(suspend).build();
        return environment -> Transformers.instanceFromFunction(LabelledFormula.class, formula -> RabinizerBuilder.build(formula, environment, configuration));
    }
}

