/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton.output;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import jhoafparser.ast.Atom;
import jhoafparser.ast.AtomLabel;
import jhoafparser.ast.BooleanExpression;
import jhoafparser.consumer.HOAConsumer;
import jhoafparser.consumer.HOAConsumerException;
import owl.automaton.Automaton;
import owl.automaton.acceptance.BooleanExpressions;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.edge.Edge;
import owl.automaton.output.HoaPrinter;
import owl.collections.ValuationSet;

final class HoaConsumerExtended<S> {
    private static final Logger log = Logger.getLogger(HoaConsumerExtended.class.getName());
    private final int alphabetSize;
    private final HOAConsumer consumer;
    private final EnumSet<HoaPrinter.HoaOption> options;
    private final Object2IntMap<S> stateNumbers;
    @Nullable
    private S currentState = null;
    final Visitor visitor = new Visitor();

    HoaConsumerExtended(HOAConsumer consumer, List<String> aliases, OmegaAcceptance acceptance, Set<S> initialStates, EnumSet<HoaPrinter.HoaOption> options, boolean isDeterministic, String name) {
        this.consumer = consumer;
        this.options = EnumSet.copyOf(options);
        this.stateNumbers = new Object2IntOpenHashMap();
        this.alphabetSize = aliases.size();
        try {
            consumer.notifyHeaderStart("v1");
            consumer.setTool(HoaConsumerExtended.tool(), HoaConsumerExtended.version());
            if (options.contains((Object)HoaPrinter.HoaOption.ANNOTATIONS)) {
                consumer.setName(name);
            }
            for (S state : initialStates) {
                consumer.addStartStates(List.of(Integer.valueOf(this.getStateId(state))));
            }
            String accName = acceptance.name();
            if (accName != null) {
                consumer.provideAcceptanceName(accName, acceptance.nameExtra());
            }
            consumer.setAcceptanceCondition(acceptance.acceptanceSets(), acceptance.booleanExpression());
            if (!initialStates.isEmpty() && isDeterministic) {
                consumer.addProperties(List.of("deterministic"));
            }
            consumer.addProperties(List.of("trans-acc", "trans-label"));
            consumer.setAPs(aliases);
            consumer.notifyBodyStart();
        }
        catch (HOAConsumerException ex) {
            log.log(Level.SEVERE, "HOAConsumer could not perform API call: ", ex);
        }
    }

    private static String tool() {
        String title = HoaConsumerExtended.class.getPackage().getImplementationTitle();
        return title == null ? "owl" : title;
    }

    private static String version() {
        String version = HoaConsumerExtended.class.getPackage().getImplementationVersion();
        return version == null ? "development" : version;
    }

    private void addEdgeBackend(BooleanExpression<AtomLabel> label, S end, IntList accSets) {
        try {
            this.consumer.addEdgeWithLabel(this.getStateId(this.currentState), label, List.of(Integer.valueOf(this.getStateId(end))), (List)(accSets.isEmpty() ? null : accSets));
        }
        catch (HOAConsumerException ex) {
            log.log(Level.SEVERE, "HOAConsumer could not perform API call: ", ex);
        }
    }

    private int getStateId(@Nullable S state) {
        Preconditions.checkState((state != null ? 1 : 0) != 0);
        return this.stateNumbers.computeIntIfAbsent(state, k -> this.stateNumbers.size());
    }

    void done() {
        try {
            this.consumer.notifyEnd();
        }
        catch (HOAConsumerException ex) {
            log.log(Level.SEVERE, "HOAConsumer could not perform API call: ", ex);
        }
    }

    class Visitor
    implements Automaton.EdgeVisitor<S>,
    Automaton.EdgeMapVisitor<S> {
        Visitor() {
        }

        @Override
        public void enter(S state) {
            HoaConsumerExtended.this.currentState = state;
            String label = HoaConsumerExtended.this.options.contains((Object)HoaPrinter.HoaOption.ANNOTATIONS) ? state.toString() : null;
            try {
                HoaConsumerExtended.this.consumer.addState(HoaConsumerExtended.this.getStateId(state), label, null, null);
            }
            catch (HOAConsumerException ex) {
                log.log(Level.SEVERE, "HOAConsumer could not perform API call: ", ex);
            }
        }

        @Override
        public void exit(S state) {
            Preconditions.checkState((boolean)state.equals(HoaConsumerExtended.this.currentState));
            try {
                HoaConsumerExtended.this.consumer.notifyEndOfState(HoaConsumerExtended.this.getStateId(HoaConsumerExtended.this.currentState));
            }
            catch (HOAConsumerException ex) {
                log.log(Level.SEVERE, "HOAConsumer could not perform API call: ", ex);
            }
        }

        @Override
        public void visit(S state, BitSet valuation, Edge<S> edge) {
            IntArrayList accSets = new IntArrayList();
            edge.acceptanceSetIterator().forEachRemaining(arg_0 -> ((IntArrayList)accSets).add(arg_0));
            ArrayList conjuncts = new ArrayList(HoaConsumerExtended.this.alphabetSize);
            for (int i = 0; i < HoaConsumerExtended.this.alphabetSize; ++i) {
                BooleanExpression atom = new BooleanExpression((Atom)AtomLabel.createAPIndex((Integer)i));
                if (valuation.get(i)) {
                    conjuncts.add(atom);
                    continue;
                }
                conjuncts.add(atom.not());
            }
            HoaConsumerExtended.this.addEdgeBackend(BooleanExpressions.createConjunction(conjuncts), edge.successor(), (IntList)accSets);
        }

        @Override
        public void visit(S state, Map<Edge<S>, ValuationSet> edgeMap) {
            edgeMap.forEach((edge, valuationSet) -> {
                Object end = edge.successor();
                if (valuationSet.isEmpty()) {
                    return;
                }
                IntArrayList acceptanceSets = new IntArrayList();
                edge.acceptanceSetIterator().forEachRemaining(arg_0 -> ((IntArrayList)acceptanceSets).add(arg_0));
                HoaConsumerExtended.this.addEdgeBackend(valuationSet.toExpression(), end, (IntList)acceptanceSets);
            });
        }
    }
}

