/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.jbdd;

import de.tum.in.jbdd.BitUtil;
import de.tum.in.jbdd.PrimeTest;

final class MathUtil {
    private static final int BYTE_MASK = BitUtil.intMaskLength(8);
    private static final int FNV_OFFSET = -2128831035;
    private static final int FNV_PRIME = 16777619;

    private MathUtil() {
    }

    private static int fnv1aRound(int hash, int number) {
        return (hash ^ number >>> 24 & BYTE_MASK ^ number >>> 16 & BYTE_MASK ^ number >>> 8 & BYTE_MASK ^ number & BYTE_MASK) * 16777619;
    }

    private static int fnv1aRound(int hash, long number) {
        return MathUtil.fnv1aRound(MathUtil.fnv1aRound(hash, (int)(number >>> 32)), (int)number);
    }

    public static int hash(long firstKey, int secondKey) {
        return MathUtil.fnv1aRound(MathUtil.fnv1aRound(-2128831035, firstKey), secondKey);
    }

    public static int hash(long firstKey, long secondKey) {
        return MathUtil.fnv1aRound(MathUtil.fnv1aRound(-2128831035, firstKey), secondKey);
    }

    public static int hash(int key) {
        return MathUtil.fnv1aRound(-2128831035, key);
    }

    public static int hash(long key) {
        return MathUtil.fnv1aRound(-2128831035, key);
    }

    public static int hash(int key, int[] keys) {
        int hash = MathUtil.fnv1aRound(-2128831035, key);
        for (int arrayKey : keys) {
            hash = MathUtil.fnv1aRound(hash, arrayKey);
        }
        return hash;
    }

    public static int nextPrime(int prime) {
        int nextPrime = Math.max(3, prime | 1);
        while (!PrimeTest.isPrime(nextPrime)) {
            nextPrime += 2;
        }
        return nextPrime;
    }
}

