/*
 * Decompiled with CFR 0.152.
 */
package owl.run.parser;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.ParseException;
import owl.run.Environment;
import owl.run.Pipeline;
import owl.run.modules.OwlModule;
import owl.run.modules.OwlModuleRegistry;

public final class PipelineParser {
    private PipelineParser() {
    }

    public static Pipeline parse(List<ModuleDescription> arguments, CommandLineParser parser, OwlModuleRegistry registry, Environment environment) throws OwlModuleRegistry.OwlModuleNotFoundException, ModuleParseException {
        Iterator<ModuleDescription> iterator = arguments.iterator();
        ModuleDescription readerDescription = iterator.next();
        OwlModule.InputReader reader = PipelineParser.parseModule(parser, registry.getReader(readerDescription.name), readerDescription, environment);
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException("No output specified");
        }
        ModuleDescription currentDescription = iterator.next();
        ArrayList<OwlModule.Transformer> transformers = new ArrayList<OwlModule.Transformer>();
        while (iterator.hasNext()) {
            transformers.add(PipelineParser.parseModule(parser, registry.getTransformer(currentDescription.name), currentDescription, environment));
            currentDescription = iterator.next();
        }
        ModuleDescription output = currentDescription;
        OwlModule.OutputWriter writer = PipelineParser.parseModule(parser, registry.getWriter(output.name), currentDescription, environment);
        return Pipeline.of(reader, transformers, writer);
    }

    static List<ModuleDescription> split(List<String> arguments, Predicate<String> separator) {
        if (arguments.isEmpty()) {
            return List.of();
        }
        Iterator<String> iterator = arguments.iterator();
        if (separator.test(arguments.get(0))) {
            iterator.next();
        }
        ArrayList<ModuleDescription> result = new ArrayList<ModuleDescription>();
        while (iterator.hasNext()) {
            String next;
            String moduleName = iterator.next();
            Preconditions.checkArgument((!separator.test(moduleName) ? 1 : 0) != 0, (Object)("Empty module description " + moduleName));
            ArrayList<String> moduleArguments = new ArrayList<String>();
            while (iterator.hasNext() && !separator.test(next = iterator.next())) {
                moduleArguments.add(next);
            }
            result.add(new ModuleDescription(moduleName, (String[])moduleArguments.toArray(String[]::new)));
        }
        return result;
    }

    private static <T extends OwlModule.Instance> T parseModule(CommandLineParser parser, OwlModule<T> settings, ModuleDescription description, Environment environment) throws ModuleParseException {
        OwlModule.Instance result;
        try {
            CommandLine commandLine = parser.parse(settings.options(), description.arguments);
            result = (OwlModule.Instance)settings.constructor().newInstance(commandLine, environment);
            List argList = commandLine.getArgList();
            if (!argList.isEmpty()) {
                ParseException parseException = new ParseException("Unmatched arguments " + argList);
                throw new ModuleParseException(parseException, settings);
            }
        }
        catch (ParseException e) {
            throw new ModuleParseException(e, settings);
        }
        return (T)result;
    }

    public static class ModuleParseException
    extends Exception {
        public final OwlModule<?> settings;

        ModuleParseException(ParseException cause, OwlModule<?> settings) {
            super(cause.getMessage(), cause);
            this.settings = settings;
        }

        @Override
        public ParseException getCause() {
            return (ParseException)super.getCause();
        }
    }

    static final class ModuleDescription {
        public final String name;
        public final String[] arguments;

        ModuleDescription(String name, String[] arguments) {
            this.name = name;
            this.arguments = (String[])arguments.clone();
        }
    }
}

