/*
 * Decompiled with CFR 0.152.
 */
package owl.util;

import com.google.common.collect.BiMap;
import java.util.BitSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class BitSetUtil {
    private BitSetUtil() {
    }

    public static <S> BitSet all(BiMap<S, Integer> stateMap) {
        return BitSetUtil.fromSet(stateMap.keySet(), stateMap);
    }

    public static <S> BitSet fromSet(Set<S> set, BiMap<S, Integer> stateMap) {
        return BitSetUtil.fromSet(set, arg_0 -> stateMap.get(arg_0), stateMap.size());
    }

    public static <S> BitSet fromSet(Set<S> set, Function<S, Integer> stateMap, int totalSize) {
        BitSet bs = new BitSet(totalSize);
        set.stream().map(stateMap).forEach(bs::set);
        return bs;
    }

    public static <S> Set<S> toSet(BitSet bs, Function<Integer, S> stateMap) {
        return bs.stream().mapToObj(stateMap::apply).collect(Collectors.toSet());
    }

    public static int toInt(BitSet bs) {
        return bs.isEmpty() ? 0 : (int)bs.toLongArray()[0];
    }

    public static BitSet fromInt(int i) {
        return BitSet.valueOf(new long[]{i});
    }

    public static BitSet union(BitSet a, BitSet b) {
        BitSet ret = (BitSet)a.clone();
        ret.or(b);
        return ret;
    }

    public static BitSet intersection(BitSet a, BitSet b) {
        BitSet ret = (BitSet)a.clone();
        ret.and(b);
        return ret;
    }

    public static BitSet without(BitSet a, BitSet b) {
        BitSet ret = (BitSet)a.clone();
        ret.andNot(b);
        return ret;
    }
}

