/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import owl.automaton.Automaton;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.edge.Edge;
import owl.collections.ValuationSet;

public interface EdgeTreeAutomatonMixin<S, A extends OmegaAcceptance>
extends Automaton<S, A> {
    public static final List<Automaton.PreferredEdgeAccess> ACCESS_MODES = List.of(Automaton.PreferredEdgeAccess.EDGE_TREE, Automaton.PreferredEdgeAccess.EDGE_MAP, Automaton.PreferredEdgeAccess.EDGES);

    @Override
    default public Map<Edge<S>, ValuationSet> edgeMap(S state) {
        return this.edgeTree(state).inverse(this.factory());
    }

    @Override
    default public Set<Edge<S>> edges(S state) {
        return this.edgeTree(state).flatValues();
    }

    @Override
    default public Set<Edge<S>> edges(S state, BitSet valuation) {
        return this.edgeTree(state).get(valuation);
    }

    @Override
    default public Set<S> successors(S state) {
        return this.edgeTree(state).flatValues(Edge::successor);
    }

    @Override
    default public List<Automaton.PreferredEdgeAccess> preferredEdgeAccess() {
        return ACCESS_MODES;
    }
}

