/*
 * Decompiled with CFR 0.152.
 */
package owl.automaton;

import de.tum.in.naturals.bitset.BitSets;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import owl.automaton.Automaton;
import owl.automaton.acceptance.OmegaAcceptance;
import owl.automaton.edge.Edge;
import owl.collections.ValuationSet;
import owl.collections.ValuationTree;
import owl.factories.ValuationSetFactory;

public interface EdgesAutomatonMixin<S, A extends OmegaAcceptance>
extends Automaton<S, A> {
    public static final List<Automaton.PreferredEdgeAccess> ACCESS_MODES = List.of(Automaton.PreferredEdgeAccess.EDGES, Automaton.PreferredEdgeAccess.EDGE_MAP, Automaton.PreferredEdgeAccess.EDGE_TREE);

    @Override
    default public Set<Edge<S>> edges(S state) {
        HashSet<Edge<S>> edges = new HashSet<Edge<S>>();
        for (BitSet valuation : BitSets.powerSet((int)this.factory().atomicPropositions().size())) {
            edges.addAll(this.edges(state, valuation));
        }
        return edges;
    }

    @Override
    default public Map<Edge<S>, ValuationSet> edgeMap(S state) {
        ValuationSetFactory factory = this.factory();
        HashMap<Edge<S>, ValuationSet> labelledEdges = new HashMap<Edge<S>, ValuationSet>();
        for (BitSet valuation : BitSets.powerSet((int)factory.atomicPropositions().size())) {
            for (Edge<S> edge : this.edges(state, valuation)) {
                labelledEdges.merge(edge, factory.of(valuation), ValuationSet::union);
            }
        }
        return labelledEdges;
    }

    @Override
    default public ValuationTree<Edge<S>> edgeTree(S state) {
        return this.factory().inverse(this.edgeMap(state));
    }

    @Override
    default public List<Automaton.PreferredEdgeAccess> preferredEdgeAccess() {
        return ACCESS_MODES;
    }
}

