/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.nba2ldba;

import com.google.common.collect.Sets;
import de.tum.in.naturals.bitset.BitSets;
import java.io.IOException;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import owl.automaton.Automaton;
import owl.automaton.AutomatonUtil;
import owl.automaton.MutableAutomatonUtil;
import owl.automaton.TwoPartAutomaton;
import owl.automaton.acceptance.AllAcceptance;
import owl.automaton.acceptance.BuchiAcceptance;
import owl.automaton.acceptance.GeneralizedBuchiAcceptance;
import owl.automaton.acceptance.OmegaAcceptanceCast;
import owl.automaton.acceptance.optimization.AcceptanceOptimizations;
import owl.automaton.algorithm.SccDecomposition;
import owl.automaton.determinization.Determinization;
import owl.automaton.edge.Edge;
import owl.automaton.edge.Edges;
import owl.collections.Either;
import owl.collections.ValuationSet;
import owl.collections.ValuationTree;
import owl.factories.ValuationSetFactory;
import owl.run.modules.InputReaders;
import owl.run.modules.OutputWriters;
import owl.run.modules.OwlModule;
import owl.run.parser.PartialConfigurationParser;
import owl.run.parser.PartialModuleConfiguration;
import owl.translations.nba2ldba.BreakpointState;

public final class NBA2LDBA
implements Function<Automaton<?, ?>, Automaton<?, BuchiAcceptance>> {
    public static final OwlModule<OwlModule.Transformer> MODULE = OwlModule.of("nba2ldba", "Converts a non-deterministic B\u00fcchi automaton into a limit-deterministic B\u00fcchi automaton", (commandLine, environment) -> OwlModule.AutomatonTransformer.of(automaton -> new NBA2LDBA().apply((Automaton<?, ?>)automaton)));

    @Override
    public Automaton<?, BuchiAcceptance> apply(Automaton<?, ?> automaton) {
        return NBA2LDBA.applyLDBA(automaton).automaton();
    }

    public static AutomatonUtil.LimitDeterministicGeneralizedBuchiAutomaton<?, BuchiAcceptance> applyLDBA(Automaton<?, ?> automaton) {
        Object ldba;
        GeneralizedBuchiAcceptance ngba = automaton.acceptance() instanceof AllAcceptance ? OmegaAcceptanceCast.cast(Determinization.determinizeAllAcceptance(OmegaAcceptanceCast.cast(automaton, AllAcceptance.class)), BuchiAcceptance.class) : OmegaAcceptanceCast.cast(automaton, GeneralizedBuchiAcceptance.class);
        if (automaton.acceptance() instanceof BuchiAcceptance && ((Optional)(ldba = AutomatonUtil.ldbaSplit(OmegaAcceptanceCast.cast(ngba, BuchiAcceptance.class)))).isPresent()) {
            return (AutomatonUtil.LimitDeterministicGeneralizedBuchiAutomaton)((Optional)ldba).get();
        }
        ldba = MutableAutomatonUtil.asMutable(new BreakpointAutomaton(ngba));
        AcceptanceOptimizations.removeDeadStates(ldba);
        return AutomatonUtil.LimitDeterministicGeneralizedBuchiAutomaton.of(ldba, ldba.states().stream().filter(x -> x.type() == Either.Type.LEFT).collect(Collectors.toSet()));
    }

    public static void main(String ... args) throws IOException {
        PartialConfigurationParser.run(args, PartialModuleConfiguration.of(InputReaders.HOA_INPUT_MODULE, List.of(AcceptanceOptimizations.MODULE), MODULE, List.of(AcceptanceOptimizations.MODULE), OutputWriters.HOA_OUTPUT_MODULE));
    }

    static final class BreakpointAutomaton<S>
    extends TwoPartAutomaton<S, BreakpointState<S>, BuchiAcceptance> {
        private final Automaton<S, ? extends GeneralizedBuchiAcceptance> ngba;
        private final List<Set<S>> sccs;
        private final int acceptanceSets;

        BreakpointAutomaton(Automaton<S, ? extends GeneralizedBuchiAcceptance> ngba) {
            this.ngba = ngba;
            this.sccs = SccDecomposition.of(ngba).sccsWithoutTransient();
            this.acceptanceSets = Math.max(ngba.acceptance().acceptanceSets(), 1);
        }

        @Override
        protected Set<S> initialStatesA() {
            return this.ngba.initialStates();
        }

        @Override
        protected Set<BreakpointState<S>> initialStatesB() {
            return Set.of();
        }

        @Override
        protected ValuationTree<Edge<S>> edgeTreeA(S state) {
            return this.ngba.edgeTree(state).map(x -> x.stream().map(Edge::withoutAcceptance).collect(Collectors.toUnmodifiableSet()));
        }

        @Override
        protected ValuationTree<Edge<BreakpointState<S>>> edgeTreeB(BreakpointState<S> state) {
            ValuationSetFactory factory = this.factory();
            HashMap<Edge<BreakpointState<S>>, ValuationSet> labelledEdges = new HashMap<Edge<BreakpointState<S>>, ValuationSet>();
            for (BitSet valuation : BitSets.powerSet((int)factory.atomicPropositions().size())) {
                for (Edge<BreakpointState<S>> edge : this.edgesB(state, valuation)) {
                    labelledEdges.merge(edge, factory.of(valuation), ValuationSet::union);
                }
            }
            return factory.inverse(labelledEdges);
        }

        @Override
        protected Set<Edge<BreakpointState<S>>> edgesB(BreakpointState<S> ldbaState, BitSet valuation) {
            Set n1;
            int i1;
            Optional<Set> optionalScc = this.sccs.stream().filter(x -> x.containsAll(ldbaState.mx())).findAny();
            if (optionalScc.isEmpty()) {
                return Set.of();
            }
            Set scc = optionalScc.get();
            Set outEdgesM = ldbaState.mx().stream().flatMap(x -> this.ngba.edges(x, valuation).stream()).filter(x -> scc.contains(x.successor())).collect(Collectors.toSet());
            if (outEdgesM.isEmpty()) {
                return Set.of();
            }
            Set outEdgesN = ldbaState.nx().stream().flatMap(x -> this.ngba.edges(x, valuation).stream()).filter(x -> scc.contains(x.successor())).collect(Collectors.toSet());
            Set intersection = outEdgesM.stream().filter(x -> x.inSet(ldbaState.ix() % this.acceptanceSets)).collect(Collectors.toSet());
            outEdgesN.addAll(intersection);
            if (outEdgesM.equals(outEdgesN)) {
                i1 = (ldbaState.ix() + 1) % this.acceptanceSets;
                n1 = Edges.successors(Sets.filter(outEdgesM, x -> x.inSet(i1)));
            } else {
                i1 = ldbaState.ix();
                n1 = Edges.successors(outEdgesN);
            }
            BreakpointState successor = BreakpointState.of(i1, Edges.successors(outEdgesM), n1);
            return Set.of(i1 == 0 && outEdgesM.equals(outEdgesN) ? Edge.of(successor, 0) : Edge.of(successor));
        }

        @Override
        protected Set<BreakpointState<S>> moveAtoB(S state) {
            for (Set<S> scc : this.sccs) {
                if (!scc.contains(state)) continue;
                return Set.of(BreakpointState.of(0, Set.of(state), Set.of()));
            }
            return Set.of();
        }

        @Override
        public BuchiAcceptance acceptance() {
            return BuchiAcceptance.INSTANCE;
        }

        @Override
        public ValuationSetFactory factory() {
            return this.ngba.factory();
        }
    }
}

