/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.nbadet;

import com.google.auto.value.AutoValue;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import owl.collections.Pair;
import owl.run.RunUtil;
import owl.translations.nbadet.AutoValue_NbaDetArgs;
import owl.translations.nbadet.NbaDetConf;
import owl.translations.nbadet.NbaLangInclusions;

@AutoValue
public abstract class NbaDetArgs {
    private static final Option optVerbosity = Option.builder((String)"v").longOpt("verbosity").desc("Set nbadet log verbosity level (e.g. INFO, WARNING, FINE, FINER, FINEST)").hasArg().argName("level").type(String.class).build();
    private static final Option optMergeMode = Option.builder((String)"m").longOpt("merge-mode").desc("Which merge method to use in construction (0=Muller-Schupp, 1=Safra, 2=Maximal merge)").hasArg().argName("mode").type(Number.class).build();
    private static final Option optComputeSims = Option.builder((String)"l").longOpt("compute-lang-inclusions").desc("List of algorithms to use on NBA to obtain language inclusions.").hasArgs().argName("sims").valueSeparator(',').type(String.class).build();
    private static final Option optSimExt = Option.builder((String)"e").longOpt("use-sim-external").desc("Use results of simulation calculation for preprocessing and optimization.").build();
    private static final Option optSimInt = Option.builder((String)"j").longOpt("use-sim-internal").desc("Use results of simulation calculation to prune the deterministic states.").build();
    private static final Option optUsePowersets = Option.builder((String)"t").longOpt("use-powersets").desc("Use powerset structure of NBA to guide determinization").build();
    private static final Option optUseSmartSucc = Option.builder((String)"s").longOpt("use-smart-succ").desc("Try to redirect edges to suitable already existing states on-the-fly").build();
    private static final Option optSepRej = Option.builder((String)"r").longOpt("sep-rej").desc("Separate simplified handling for states in rejecting SCCs").build();
    private static final Option optSepAcc = Option.builder((String)"A").longOpt("sep-acc").desc("Separate simplified handling for states in accepting SCCs").build();
    private static final Option optSepAccCyc = Option.builder((String)"b").longOpt("sep-acc-cycle").desc("Cycle breakpoint construction for accepting SCCs").build();
    private static final Option optSepDet = Option.builder((String)"d").longOpt("sep-det").desc("Separate simplified handling for deterministic SCCs").build();
    private static final Option optSepMix = Option.builder((String)"c").longOpt("sep-sccs").desc("Separate handling of all SCCs (that are not already specially handled)").build();
    private static final Option optDefaultConfig = Option.builder((String)"z").longOpt("default-config").desc("Use a suggested configuration that works well most of the time, which is:\n" + NbaDetArgs.getDefault().toString()).build();
    public static final Options options = new Options().addOption(optVerbosity).addOption(optMergeMode).addOption(optComputeSims).addOption(optSimExt).addOption(optSimInt).addOption(optUsePowersets).addOption(optUseSmartSucc).addOption(optSepRej).addOption(optSepAcc).addOption(optSepAccCyc).addOption(optSepDet).addOption(optSepMix).addOption(optDefaultConfig);

    public abstract NbaDetConf.UpdateMode mergeMode();

    public abstract Level verbosity();

    public abstract Set<Pair<NbaLangInclusions.SimType, String>> computeSims();

    public abstract boolean simExt();

    public abstract boolean simInt();

    public abstract boolean usePowersets();

    public abstract boolean useSmartSucc();

    public abstract boolean sepRej();

    public abstract boolean sepAcc();

    public abstract boolean sepAccCyc();

    public abstract boolean sepDet();

    public abstract boolean sepMix();

    public static Builder builder() {
        return new AutoValue_NbaDetArgs.Builder().setVerbosity(Level.WARNING).setMergeMode(NbaDetConf.UpdateMode.SAFRA).setComputeSims(Set.of());
    }

    public abstract Builder toBuilder();

    public static NbaDetArgs getDefault() {
        return NbaDetArgs.builder().setMergeMode(NbaDetConf.UpdateMode.SAFRA).setComputeSims(Set.of(Pair.of(NbaLangInclusions.SimType.DIRECT_REFINEMENT_SIM, ""))).setSimExt(true).setSimInt(true).setUsePowersets(true).setUseSmartSucc(true).setSepDet(true).setSepMix(true).setSepRej(true).setSepAcc(false).setSepAccCyc(false).build();
    }

    public static NbaDetConf.UpdateMode extractMergeMode(CommandLine cmdLine, String arg) {
        try {
            int mode = ((Number)cmdLine.getParsedOptionValue(arg)).intValue();
            if (mode < 0 || mode >= NbaDetConf.UpdateMode.values().length) {
                throw new IllegalArgumentException();
            }
            return NbaDetConf.UpdateMode.values()[mode];
        }
        catch (IllegalArgumentException | ParseException e) {
            RunUtil.failWithMessage("failed to parse provided merge mode value! Merge mode must be a value in the range [0," + (NbaDetConf.UpdateMode.values().length - 1) + "].");
            return NbaDetArgs.getDefault().mergeMode();
        }
    }

    public static Set<Pair<NbaLangInclusions.SimType, String>> extractSims(CommandLine cmdLine, String arg) {
        String[] simlist = cmdLine.getOptionValues(optComputeSims.getOpt());
        Set<Pair<NbaLangInclusions.SimType, String>> ret = Set.of();
        Map<String, NbaLangInclusions.SimType> simArgs = NbaLangInclusions.getAlgoArgs();
        try {
            ret = Arrays.stream(simlist).map(str -> {
                String[] kv = str.split("@");
                if (!simArgs.containsKey(kv[0])) {
                    throw new IllegalArgumentException();
                }
                NbaLangInclusions.SimType simType = (NbaLangInclusions.SimType)((Object)((Object)simArgs.get(kv[0])));
                String simArg = kv.length == 1 ? "" : kv[1];
                return Pair.of(simType, simArg);
            }).collect(Collectors.toUnmodifiableSet());
        }
        catch (IllegalArgumentException e) {
            RunUtil.failWithMessage("failed to parse provided list of simulations to compute! Must be a comma-separated list of algorithms from " + simArgs.keySet().toString());
        }
        return ret;
    }

    public static NbaDetArgs getFromCli(CommandLine cmdLine) {
        if (cmdLine.hasOption(optDefaultConfig.getOpt())) {
            return NbaDetArgs.getDefault();
        }
        Builder bldr = NbaDetArgs.builder();
        if (cmdLine.hasOption(optVerbosity.getOpt())) {
            bldr.setVerbosity(Level.parse(cmdLine.getOptionValue(optVerbosity.getOpt())));
        }
        if (cmdLine.hasOption(optMergeMode.getOpt())) {
            bldr.setMergeMode(NbaDetArgs.extractMergeMode(cmdLine, optMergeMode.getOpt()));
        }
        if (cmdLine.hasOption(optComputeSims.getOpt())) {
            bldr.setComputeSims(NbaDetArgs.extractSims(cmdLine, optComputeSims.getOpt()));
        }
        bldr.setSimInt(cmdLine.hasOption(optSimInt.getOpt()));
        bldr.setSimExt(cmdLine.hasOption(optSimExt.getOpt()));
        bldr.setUsePowersets(cmdLine.hasOption(optUsePowersets.getOpt()));
        bldr.setUseSmartSucc(cmdLine.hasOption(optUseSmartSucc.getOpt()));
        bldr.setSepAcc(cmdLine.hasOption(optSepAcc.getOpt()));
        bldr.setSepAccCyc(cmdLine.hasOption(optSepAccCyc.getOpt()));
        bldr.setSepRej(cmdLine.hasOption(optSepRej.getOpt()));
        bldr.setSepDet(cmdLine.hasOption(optSepDet.getOpt()));
        bldr.setSepMix(cmdLine.hasOption(optSepMix.getOpt()));
        return bldr.build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setVerbosity(Level var1);

        public abstract Builder setMergeMode(NbaDetConf.UpdateMode var1);

        public abstract Builder setComputeSims(Set<Pair<NbaLangInclusions.SimType, String>> var1);

        public abstract Builder setSimExt(boolean var1);

        public abstract Builder setSimInt(boolean var1);

        public abstract Builder setUsePowersets(boolean var1);

        public abstract Builder setUseSmartSucc(boolean var1);

        public abstract Builder setSepRej(boolean var1);

        public abstract Builder setSepAcc(boolean var1);

        public abstract Builder setSepAccCyc(boolean var1);

        public abstract Builder setSepDet(boolean var1);

        public abstract Builder setSepMix(boolean var1);

        public abstract NbaDetArgs build();
    }
}

