/*
 * Decompiled with CFR 0.152.
 */
package de.tum.in.naturals.set;

import de.tum.in.naturals.BitUtil;
import de.tum.in.naturals.set.AbstractBoundedNatBitSet;
import de.tum.in.naturals.set.BoundedNatBitSet;
import de.tum.in.naturals.set.NatBitSetIterator;
import de.tum.in.naturals.set.NatBitSetsUtil;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nonnegative;

class LongBoundedNatBitSet
extends AbstractBoundedNatBitSet {
    private final boolean complement;
    private final LongBoundedNatBitSet complementView;
    private final long domainMask;
    private final long[] store;

    private LongBoundedNatBitSet(long store, int domainSize, boolean complement) {
        super(domainSize);
        if (64 < domainSize) {
            throw new IllegalArgumentException();
        }
        this.store = new long[]{store};
        this.complement = complement;
        this.domainMask = BitUtil.maskTo(this.domainSize());
        this.complementView = new LongBoundedNatBitSet(this);
        assert (this.checkConsistency());
    }

    private LongBoundedNatBitSet(LongBoundedNatBitSet other) {
        super(other.domainSize());
        this.complementView = other;
        this.complement = !other.complement;
        this.store = other.store;
        this.domainMask = other.domainMask;
    }

    LongBoundedNatBitSet(long store, @Nonnegative int domainSize) {
        this(store, domainSize, false);
    }

    LongBoundedNatBitSet(int domainSize) {
        this(0L, domainSize, false);
    }

    public static int maximalSize() {
        return 64;
    }

    @Override
    boolean isComplement() {
        return this.complement;
    }

    public boolean isEmpty() {
        assert (this.checkConsistency());
        return this.store[0] == (this.complement ? this.domainMask : 0L);
    }

    public int size() {
        assert (this.checkConsistency());
        int bitCount = Long.bitCount(this.store[0]);
        return this.complement ? this.domainSize() - bitCount : bitCount;
    }

    public boolean contains(int index) {
        assert (this.checkConsistency());
        return this.inDomain(index) && this.containsIndex(index);
    }

    public boolean containsAll(IntCollection indices) {
        assert (this.checkConsistency());
        if (this.isEmpty()) {
            return indices.isEmpty();
        }
        if (indices.isEmpty()) {
            return true;
        }
        if (indices instanceof LongBoundedNatBitSet) {
            LongBoundedNatBitSet other = (LongBoundedNatBitSet)indices;
            long otherSetBits = other.complement ? other.complementBits() : other.store[0];
            long unsetBits = this.complement ? this.store[0] | this.domainMask ^ 0xFFFFFFFFFFFFFFFFL : this.store[0] ^ 0xFFFFFFFFFFFFFFFFL;
            return (unsetBits & otherSetBits) == 0L;
        }
        return super.containsAll(indices);
    }

    @Override
    public int firstInt() {
        assert (this.checkConsistency());
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        int first = Long.numberOfTrailingZeros(this.complement ? this.store[0] ^ 0xFFFFFFFFFFFFFFFFL : this.store[0]);
        assert (first < 64 && this.containsIndex(first));
        return first;
    }

    @Override
    public int lastInt() {
        assert (this.checkConsistency());
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        int last = 64 - Long.numberOfLeadingZeros(this.complement ? this.complementBits() : this.store[0]) - 1;
        assert (0 <= last && this.containsIndex(last));
        return last;
    }

    @Override
    public int nextPresentIndex(int index) {
        assert (this.checkConsistency());
        NatBitSetsUtil.checkNonNegative(index);
        if (index >= this.domainSize() || this.isEmpty()) {
            return -1;
        }
        long masked = (this.complement ? this.complementBits() : this.store[0]) & (BitUtil.maskTo(index) ^ 0xFFFFFFFFFFFFFFFFL);
        if (masked == 0L) {
            return -1;
        }
        int next = Long.numberOfTrailingZeros(masked);
        assert (next < 64 && this.containsIndex(next)) : next;
        return next;
    }

    @Override
    public int nextAbsentIndex(int index) {
        assert (this.checkConsistency());
        NatBitSetsUtil.checkNonNegative(index);
        if (index >= this.domainSize() || this.isEmpty()) {
            return index;
        }
        long masked = (this.complement ? this.store[0] : this.complementBits()) & (BitUtil.maskTo(index) ^ 0xFFFFFFFFFFFFFFFFL);
        if (masked == 0L) {
            return this.domainSize();
        }
        int next = Long.numberOfTrailingZeros(masked);
        assert (next < 64 && !this.containsIndex(next)) : next;
        return next;
    }

    @Override
    public int previousPresentIndex(int index) {
        assert (this.checkConsistency());
        NatBitSetsUtil.checkNonNegative(index);
        if (this.isEmpty()) {
            return -1;
        }
        long masked = (this.complement ? this.complementBits() : this.store[0]) & BitUtil.maskTo(index + 1);
        if (masked == 0L) {
            return -1;
        }
        int previous = 64 - Long.numberOfLeadingZeros(masked) - 1;
        assert (this.containsIndex(previous)) : previous;
        return previous;
    }

    @Override
    public int previousAbsentIndex(int index) {
        long mask;
        assert (this.checkConsistency());
        NatBitSetsUtil.checkNonNegative(index);
        if (index >= this.domainSize() || this.isEmpty()) {
            return index;
        }
        long masked = (this.complement ? this.store[0] : this.complementBits()) & (mask = BitUtil.maskTo(index + 1));
        if (masked == 0L) {
            return -1;
        }
        int previous = 64 - Long.numberOfLeadingZeros(masked) - 1;
        assert (!this.containsIndex(previous)) : previous;
        return previous;
    }

    @Override
    public IntIterator iterator() {
        return new NatBitSetIterator(this);
    }

    @Override
    public void set(int index) {
        assert (this.checkConsistency());
        this.checkInDomain(index);
        this.store[0] = this.complement ? this.store[0] & (1L << index ^ 0xFFFFFFFFFFFFFFFFL) : this.store[0] | 1L << index;
        assert (this.checkConsistency());
    }

    @Override
    public void set(int index, boolean value) {
        assert (this.checkConsistency());
        if (value) {
            this.set(index);
        } else {
            this.clear(index);
        }
        assert (this.checkConsistency());
    }

    @Override
    public void set(int from, int to) {
        assert (this.checkConsistency());
        this.checkInDomain(from, to);
        this.store[0] = this.complement ? this.store[0] & (BitUtil.mask(from, to) ^ 0xFFFFFFFFFFFFFFFFL) : this.store[0] | BitUtil.mask(from, to);
        assert (this.checkConsistency());
    }

    @Override
    public void clear(int index) {
        assert (this.checkConsistency());
        this.checkInDomain(index);
        this.store[0] = this.complement ? this.store[0] | 1L << index : this.store[0] & (1L << index ^ 0xFFFFFFFFFFFFFFFFL);
        assert (this.checkConsistency());
    }

    @Override
    public void clear(int from, int to) {
        assert (this.checkConsistency());
        this.checkInDomain(from, to);
        this.store[0] = this.complement ? this.store[0] | BitUtil.mask(from, to) : this.store[0] & (BitUtil.mask(from, to) ^ 0xFFFFFFFFFFFFFFFFL);
        assert (this.checkConsistency());
    }

    public void clear() {
        assert (this.checkConsistency());
        this.store[0] = this.complement ? this.domainMask : 0L;
        assert (this.checkConsistency());
    }

    @Override
    public void flip(int index) {
        assert (this.checkConsistency());
        this.checkInDomain(index);
        this.store[0] = this.store[0] ^ 1L << index;
        assert (this.checkConsistency());
    }

    @Override
    public void flip(int from, int to) {
        assert (this.checkConsistency());
        this.checkInDomain(from, to);
        this.store[0] = this.store[0] ^ BitUtil.mask(from, to);
        assert (this.checkConsistency());
    }

    @Override
    public boolean intersects(Collection<Integer> indices) {
        assert (this.checkConsistency());
        if (indices instanceof LongBoundedNatBitSet) {
            LongBoundedNatBitSet other = (LongBoundedNatBitSet)((Object)indices);
            long store = this.complement ? this.complementBits() : this.store[0];
            long otherStore = other.complement ? other.complementBits() : other.store[0];
            return (store & otherStore) != 0L;
        }
        return super.intersects(indices);
    }

    @Override
    public void and(IntCollection indices) {
        assert (this.checkConsistency());
        if (indices.isEmpty()) {
            this.clear();
        } else if (indices instanceof LongBoundedNatBitSet) {
            LongBoundedNatBitSet other = (LongBoundedNatBitSet)indices;
            if (this.complement) {
                this.store[0] = this.store[0] | (other.complement ? other.store[0] | other.domainMask ^ 0xFFFFFFFFFFFFFFFFL : other.store[0] ^ 0xFFFFFFFFFFFFFFFFL);
                this.store[0] = this.store[0] & this.domainMask;
            } else {
                this.store[0] = this.store[0] & (other.complement ? other.complementBits() : other.store[0]);
            }
        } else {
            super.and(indices);
        }
        assert (this.checkConsistency());
    }

    @Override
    public void andNot(IntCollection indices) {
        assert (this.checkConsistency());
        if (indices.isEmpty()) {
            return;
        }
        if (indices instanceof LongBoundedNatBitSet) {
            LongBoundedNatBitSet other = (LongBoundedNatBitSet)indices;
            if (this.complement) {
                this.store[0] = this.store[0] | (other.complement ? other.complementBits() : other.store[0]);
                this.store[0] = this.store[0] & this.domainMask;
            } else {
                this.store[0] = this.store[0] & (other.complement ? other.store[0] | other.domainMask ^ 0xFFFFFFFFFFFFFFFFL : other.store[0] ^ 0xFFFFFFFFFFFFFFFFL);
            }
        } else {
            super.andNot(indices);
        }
        assert (this.checkConsistency());
    }

    @Override
    public void or(IntCollection indices) {
        assert (this.checkConsistency());
        if (indices.isEmpty()) {
            return;
        }
        if (indices instanceof LongBoundedNatBitSet) {
            LongBoundedNatBitSet other = (LongBoundedNatBitSet)indices;
            this.checkInDomain(other.lastInt());
            this.store[0] = this.complement ? this.store[0] & (other.complement ? other.store[0] | other.domainMask ^ 0xFFFFFFFFFFFFFFFFL : other.store[0] ^ 0xFFFFFFFFFFFFFFFFL) : this.store[0] | (other.complement ? other.complementBits() : other.store[0]);
        } else {
            super.or(indices);
        }
        assert (this.checkConsistency());
    }

    @Override
    public void orNot(IntCollection indices) {
        assert (this.checkConsistency());
        if (indices.isEmpty()) {
            this.store[0] = this.complement ? 0L : this.domainMask;
        } else if (indices instanceof LongBoundedNatBitSet) {
            LongBoundedNatBitSet other = (LongBoundedNatBitSet)indices;
            this.store[0] = this.complement ? this.store[0] & (other.complement ? other.complementBits() : other.store[0]) : this.store[0] | ((other.complement ? other.store[0] : other.store[0] ^ 0xFFFFFFFFFFFFFFFFL) | other.domainMask ^ 0xFFFFFFFFFFFFFFFFL) & this.domainMask;
        } else {
            super.orNot(indices);
        }
        assert (this.checkConsistency());
    }

    @Override
    public void xor(IntCollection indices) {
        assert (this.checkConsistency());
        if (indices.isEmpty()) {
            return;
        }
        if (indices instanceof LongBoundedNatBitSet) {
            LongBoundedNatBitSet other = (LongBoundedNatBitSet)indices;
            this.checkInDomain(other.domainSize() - 1);
            this.store[0] = this.store[0] ^ other.store[0];
            if (other.complement) {
                this.store[0] = this.store[0] ^ other.domainMask;
            }
        } else {
            super.xor(indices);
        }
        assert (this.checkConsistency());
    }

    @Override
    public LongBoundedNatBitSet clone() {
        assert (this.checkConsistency());
        return new LongBoundedNatBitSet(this.store[0], this.domainSize(), this.complement);
    }

    @Override
    public BoundedNatBitSet complement() {
        return this.complementView;
    }

    public boolean equals(Object o) {
        assert (this.checkConsistency());
        if (this == o) {
            return true;
        }
        if (!(o instanceof Set)) {
            return false;
        }
        if (this.isEmpty()) {
            return ((Collection)o).isEmpty();
        }
        if (((Collection)o).isEmpty()) {
            return false;
        }
        if (o instanceof LongBoundedNatBitSet) {
            LongBoundedNatBitSet other = (LongBoundedNatBitSet)o;
            return (this.complement ? this.complementBits() : this.store[0]) == (other.complement ? other.complementBits() : other.store[0]);
        }
        return super.equals(o);
    }

    protected long complementBits() {
        return (this.store[0] ^ 0xFFFFFFFFFFFFFFFFL) & this.domainMask;
    }

    private boolean containsIndex(int index) {
        return (this.store[0] & 1L << index) == 0L == this.complement;
    }

    private boolean checkConsistency() {
        return (this.store[0] & (this.domainMask ^ 0xFFFFFFFFFFFFFFFFL)) == 0L;
    }
}

