/*
 * Decompiled with CFR 0.152.
 */
package owl.bdd;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import owl.bdd.MtBdd;
import owl.collections.Collections3;
import owl.collections.Pair;

public final class MtBddOperations {
    private MtBddOperations() {
    }

    public static <L, R, E> MtBdd<E> cartesianProduct(MtBdd<L> factor1, MtBdd<R> factor2, BiFunction<L, R, @Nullable E> combinator) {
        return MtBddOperations.cartesianProduct(factor1, factor2, combinator, new HashMap<Pair<MtBdd<L>, MtBdd<R>>, MtBdd<E>>());
    }

    public static <E> MtBdd<List<E>> cartesianProductWithNull(List<? extends MtBdd<E>> trees) {
        return MtBddOperations.naryCartesianProductWithNull(trees, new HashMap());
    }

    public static <E> MtBdd<List<E>> cartesianProduct(List<? extends MtBdd<E>> trees) {
        return MtBddOperations.naryCartesianProduct(trees, List::copyOf, new HashMap());
    }

    public static <K, V> MtBdd<Map<K, V>> cartesianProduct(Map<K, ? extends MtBdd<V>> trees) {
        switch (trees.size()) {
            case 0: {
                return MtBdd.of(Set.of(Map.of()));
            }
            case 1: {
                Map.Entry entry = trees.entrySet().iterator().next();
                return entry.getValue().map(x -> x.stream().map(y -> Map.of(entry.getKey(), y)).collect(Collectors.toUnmodifiableSet()));
            }
        }
        Iterator<Map.Entry<K, MtBdd<V>>> iterator = trees.entrySet().iterator();
        Map.Entry entry1 = iterator.next();
        Map.Entry entry2 = iterator.next();
        MtBdd<Map<K, V>> productTree = MtBddOperations.cartesianProduct(entry1.getValue(), entry2.getValue(), (value1, value2) -> Map.of(entry1.getKey(), value1, entry2.getKey(), value2));
        while (iterator.hasNext()) {
            Map.Entry entryN = iterator.next();
            productTree = MtBddOperations.cartesianProduct(productTree, entryN.getValue(), (x, valueN) -> Map.copyOf(Collections3.add(x, entryN.getKey(), valueN)));
        }
        return productTree;
    }

    public static <E> MtBdd<Set<E>> cartesianProduct(Set<? extends MtBdd<E>> trees) {
        switch (trees.size()) {
            case 0: {
                return MtBdd.of(Set.of(Set.of()));
            }
            case 1: {
                return trees.iterator().next().map(x -> x.stream().map(Set::of).collect(Collectors.toUnmodifiableSet()));
            }
        }
        Iterator<MtBdd<E>> iterator = trees.iterator();
        MtBdd<Set<E>> productTree = MtBddOperations.cartesianProduct(iterator.next(), iterator.next(), (x, y) -> x.equals(y) ? Set.of(x) : Set.of(x, y));
        while (iterator.hasNext()) {
            productTree = MtBddOperations.cartesianProduct(productTree, iterator.next(), (x, y) -> x.contains(y) ? x : Set.copyOf(Collections3.add(x, y)));
        }
        return productTree;
    }

    public static <E> MtBdd<E> union(MtBdd<E> tree1, MtBdd<E> tree2) {
        return MtBddOperations.union(tree1, tree2, new HashMap());
    }

    public static <E> MtBdd<E> union(Collection<? extends MtBdd<E>> trees) {
        switch (trees.size()) {
            case 0: {
                return MtBdd.of();
            }
            case 1: {
                return trees.iterator().next();
            }
        }
        Iterator<MtBdd<E>> iterator = trees.iterator();
        MtBdd<E> unionTree = MtBddOperations.union(iterator.next(), iterator.next());
        while (iterator.hasNext()) {
            unionTree = MtBddOperations.union(unionTree, iterator.next());
        }
        return unionTree;
    }

    private static <L, R, E> MtBdd<E> cartesianProduct(MtBdd<L> leftTree, MtBdd<R> rightTree, BiFunction<L, R, @Nullable E> merger, Map<Pair<MtBdd<L>, MtBdd<R>>, MtBdd<E>> memoizedCalls) {
        Pair<MtBdd<L>, MtBdd<R>> key = Pair.of(leftTree, rightTree);
        MtBdd<E> cartesianProduct = memoizedCalls.get(key);
        if (cartesianProduct != null) {
            return cartesianProduct;
        }
        int variable = MtBddOperations.nextVariable(leftTree, rightTree);
        if (variable == Integer.MAX_VALUE) {
            HashSet<E> elements = new HashSet<E>();
            for (Object leftValue : ((MtBdd.Leaf)leftTree).value) {
                for (Object rightValue : ((MtBdd.Leaf)rightTree).value) {
                    E element = merger.apply(leftValue, rightValue);
                    if (element == null) continue;
                    elements.add(element);
                }
            }
            cartesianProduct = MtBdd.of(elements);
        } else {
            MtBdd<E> falseCartesianProduct = MtBddOperations.cartesianProduct(MtBddOperations.descendFalseIf(leftTree, variable), MtBddOperations.descendFalseIf(rightTree, variable), merger, memoizedCalls);
            MtBdd<E> trueCartesianProduct = MtBddOperations.cartesianProduct(MtBddOperations.descendTrueIf(leftTree, variable), MtBddOperations.descendTrueIf(rightTree, variable), merger, memoizedCalls);
            cartesianProduct = MtBdd.of(variable, trueCartesianProduct, falseCartesianProduct);
        }
        memoizedCalls.put(key, cartesianProduct);
        return cartesianProduct;
    }

    private static <T> MtBdd<List<T>> naryCartesianProductWithNull(List<? extends MtBdd<T>> trees, Map<? super List<MtBdd<T>>, MtBdd<List<T>>> memoizedCalls) {
        MtBdd<List<Object>> cartesianProduct = memoizedCalls.get(trees);
        if (cartesianProduct != null) {
            return cartesianProduct;
        }
        int variable = MtBddOperations.nextVariable(trees);
        if (variable == Integer.MAX_VALUE) {
            ArrayList<Object> values = new ArrayList<Object>(trees.size());
            for (MtBdd<T> x2 : trees) {
                assert (x2 instanceof MtBdd.Leaf);
                MtBdd.Leaf casted = (MtBdd.Leaf)x2;
                Preconditions.checkArgument((casted.value.size() <= 1 ? 1 : 0) != 0);
                values.add(Iterables.getOnlyElement(casted.value, null));
            }
            cartesianProduct = MtBdd.of(Set.of(Collections.unmodifiableList(values)));
        } else {
            List falseTrees = trees.stream().map(x -> MtBddOperations.descendFalseIf(x, variable)).collect(Collectors.toUnmodifiableList());
            List trueTrees = trees.stream().map(x -> MtBddOperations.descendTrueIf(x, variable)).collect(Collectors.toUnmodifiableList());
            MtBdd<List<T>> falseCartesianProduct = MtBddOperations.naryCartesianProductWithNull(falseTrees, memoizedCalls);
            MtBdd<List<T>> trueCartesianProduct = MtBddOperations.naryCartesianProductWithNull(trueTrees, memoizedCalls);
            cartesianProduct = MtBdd.of(variable, trueCartesianProduct, falseCartesianProduct);
        }
        memoizedCalls.put(List.copyOf(trees), cartesianProduct);
        return cartesianProduct;
    }

    private static <T, R> MtBdd<R> naryCartesianProduct(List<? extends MtBdd<T>> trees, Function<? super List<T>, ? extends R> mapper, Map<? super List<MtBdd<T>>, MtBdd<R>> memoizedCalls) {
        MtBdd<Object> cartesianProduct = memoizedCalls.get(trees);
        if (cartesianProduct != null) {
            return cartesianProduct;
        }
        int variable = MtBddOperations.nextVariable(trees);
        if (variable == Integer.MAX_VALUE) {
            HashSet<R> elements = new HashSet<R>();
            ArrayList values = new ArrayList(trees.size());
            for (MtBdd<T> x2 : trees) {
                assert (x2 instanceof MtBdd.Leaf);
                MtBdd.Leaf casted = (MtBdd.Leaf)x2;
                values.add(casted.value);
            }
            for (List values2 : Sets.cartesianProduct(values)) {
                R element = mapper.apply(values2);
                if (element == null) continue;
                elements.add(element);
            }
            cartesianProduct = MtBdd.of(elements);
        } else {
            List falseTrees = trees.stream().map(x -> MtBddOperations.descendFalseIf(x, variable)).collect(Collectors.toUnmodifiableList());
            List trueTrees = trees.stream().map(x -> MtBddOperations.descendTrueIf(x, variable)).collect(Collectors.toUnmodifiableList());
            MtBdd<? extends R> falseCartesianProduct = MtBddOperations.naryCartesianProduct(falseTrees, mapper, memoizedCalls);
            MtBdd<? extends R> trueCartesianProduct = MtBddOperations.naryCartesianProduct(trueTrees, mapper, memoizedCalls);
            cartesianProduct = MtBdd.of(variable, trueCartesianProduct, falseCartesianProduct);
        }
        memoizedCalls.put(List.copyOf(trees), cartesianProduct);
        return cartesianProduct;
    }

    private static <E> MtBdd<E> union(MtBdd<E> tree1, MtBdd<E> tree2, Map<Set<?>, MtBdd<E>> memoizedCalls) {
        if (tree1.equals(tree2)) {
            return tree1;
        }
        Set<MtBdd<E>> key = Set.of(tree1, tree2);
        MtBdd<E> union = memoizedCalls.get(key);
        if (union != null) {
            return union;
        }
        int variable = MtBddOperations.nextVariable(tree1, tree2);
        if (variable == Integer.MAX_VALUE) {
            Set value1 = ((MtBdd.Leaf)tree1).value;
            Set value2 = ((MtBdd.Leaf)tree2).value;
            union = value1.isEmpty() ? tree2 : (value2.isEmpty() ? tree1 : MtBdd.of(Set.copyOf(Sets.union(value1, value2))));
        } else {
            MtBdd<E> falseUnionProduct = MtBddOperations.union(MtBddOperations.descendFalseIf(tree1, variable), MtBddOperations.descendFalseIf(tree2, variable), memoizedCalls);
            MtBdd<E> trueUnionProduct = MtBddOperations.union(MtBddOperations.descendTrueIf(tree1, variable), MtBddOperations.descendTrueIf(tree2, variable), memoizedCalls);
            union = MtBdd.of(variable, trueUnionProduct, falseUnionProduct);
        }
        memoizedCalls.put(key, union);
        return union;
    }

    private static int nextVariable(MtBdd<?> tree1, MtBdd<?> tree2) {
        int variable1 = tree1 instanceof MtBdd.Node ? ((MtBdd.Node)tree1).variable : Integer.MAX_VALUE;
        int variable2 = tree2 instanceof MtBdd.Node ? ((MtBdd.Node)tree2).variable : Integer.MAX_VALUE;
        return Math.min(variable1, variable2);
    }

    private static int nextVariable(Collection<? extends MtBdd<?>> trees) {
        int variable = Integer.MAX_VALUE;
        for (MtBdd<?> tree : trees) {
            variable = Math.min(variable, tree instanceof MtBdd.Node ? ((MtBdd.Node)tree).variable : Integer.MAX_VALUE);
        }
        return variable;
    }

    private static <E> MtBdd<E> descendFalseIf(MtBdd<E> tree, int variable) {
        if (tree instanceof MtBdd.Node && ((MtBdd.Node)tree).variable == variable) {
            return ((MtBdd.Node)tree).falseChild;
        }
        return tree;
    }

    private static <E> MtBdd<E> descendTrueIf(MtBdd<E> tree, int variable) {
        if (tree instanceof MtBdd.Node && ((MtBdd.Node)tree).variable == variable) {
            return ((MtBdd.Node)tree).trueChild;
        }
        return tree;
    }
}

