/*
 * Decompiled with CFR 0.152.
 */
package owl.game.algorithms;

import com.google.common.collect.Sets;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import owl.automaton.acceptance.ParityAcceptance;
import owl.automaton.edge.Edge;
import owl.game.Game;
import owl.game.GameViews;
import owl.game.algorithms.ParityGameSolver;

public final class ZielonkaGameSolver
implements ParityGameSolver {
    private static <S> ParityGameSolver.WinningRegions<S> recursiveZielonka(Game<S, ? extends ParityAcceptance> game) {
        Game.Owner ourHorse;
        Set states = game.states();
        ParityAcceptance acceptance = (ParityAcceptance)game.acceptance();
        boolean max = acceptance.parity().max();
        int extremalColour = max ? -1 : acceptance.acceptanceSets();
        for (Object state2 : states) {
            for (Edge edge : game.edges(state2)) {
                if (max) {
                    extremalColour = Math.max(extremalColour, edge.colours().last().orElse(extremalColour));
                    continue;
                }
                extremalColour = Math.min(extremalColour, edge.colours().first().orElse(extremalColour));
            }
        }
        int theExtremalColour = extremalColour;
        Game.Owner owner = ourHorse = acceptance.isAccepting(theExtremalColour) ? Game.Owner.PLAYER_2 : Game.Owner.PLAYER_1;
        if (max ? theExtremalColour == -1 : theExtremalColour == acceptance.acceptanceSets()) {
            return new ParityGameSolver.WinningRegions(states, ourHorse);
        }
        Predicate<Edge> hasExtremalColour = y -> max ? y.colours().last().orElse(-2) == theExtremalColour : y.colours().first().orElse(-2) == theExtremalColour;
        Set winningStates = Sets.filter(states, state -> {
            Objects.requireNonNull(state);
            if (game.owner(state) != Game.Owner.PLAYER_2) {
                return false;
            }
            if (Game.Owner.PLAYER_2 == ourHorse) {
                return game.edges(state).stream().anyMatch(hasExtremalColour);
            }
            return game.edges(state).stream().allMatch(hasExtremalColour);
        });
        assert (winningStates.stream().allMatch(x -> game.owner(x) == Game.Owner.PLAYER_2));
        Sets.SetView losingSet = Sets.difference(states, game.getAttractorFixpoint(winningStates, ourHorse));
        Game<Object, ? extends ParityAcceptance> subGame = GameViews.filter(game, ((Set)losingSet)::contains, hasExtremalColour.negate());
        ParityGameSolver.WinningRegions<Object> subWinning = ZielonkaGameSolver.recursiveZielonka(subGame);
        if (subWinning.winningRegion(ourHorse).containsAll(subGame.states())) {
            return new ParityGameSolver.WinningRegions(states, ourHorse);
        }
        Set<Object> opponentAttractor = game.getAttractorFixpoint(subWinning.winningRegion(ourHorse.opponent()), ourHorse.opponent());
        Sets.SetView difference = Sets.difference(states, opponentAttractor);
        ParityGameSolver.WinningRegions<Object> newSubWinning = ZielonkaGameSolver.recursiveZielonka(GameViews.filter(game, ((Set)difference)::contains));
        newSubWinning.addAll(opponentAttractor, ourHorse.opponent());
        return newSubWinning;
    }

    public static <S> boolean zielonkaRealizability(Game<S, ? extends ParityAcceptance> game) {
        return ZielonkaGameSolver.recursiveZielonka(GameViews.replaceInitialStates(game, game.states())).player2.contains(game.initialState());
    }

    @Override
    public <S> boolean realizable(Game<S, ? extends ParityAcceptance> game) {
        return ZielonkaGameSolver.zielonkaRealizability(game);
    }

    @Override
    public <S> ParityGameSolver.WinningRegions<S> solve(Game<S, ? extends ParityAcceptance> game) {
        return ZielonkaGameSolver.recursiveZielonka(game);
    }
}

