/*
 * Decompiled with CFR 0.152.
 */
package owl.ltl.visitors;

import com.google.common.collect.Comparators;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import owl.ltl.Biconditional;
import owl.ltl.BooleanConstant;
import owl.ltl.Conjunction;
import owl.ltl.Disjunction;
import owl.ltl.FOperator;
import owl.ltl.Formula;
import owl.ltl.GOperator;
import owl.ltl.Literal;
import owl.ltl.MOperator;
import owl.ltl.ROperator;
import owl.ltl.UOperator;
import owl.ltl.WOperator;
import owl.ltl.XOperator;
import owl.ltl.visitors.Visitor;

public class LatexPrintVisitor
implements Visitor<String> {
    private final List<String> alphabet;

    public LatexPrintVisitor(List<String> alphabet) {
        this.alphabet = List.copyOf(alphabet);
    }

    @Override
    public String visit(BooleanConstant booleanConstant) {
        return booleanConstant.value ? " \\true " : " \\false ";
    }

    @Override
    public String visit(Conjunction conjunction) {
        return this.visit(conjunction, " \\wedge ");
    }

    @Override
    public String visit(Disjunction disjunction) {
        return this.visit(disjunction, " \\vee ");
    }

    @Override
    public String visit(FOperator fOperator) {
        return this.visit((Formula.UnaryTemporalOperator)fOperator);
    }

    @Override
    public String visit(GOperator gOperator) {
        return this.visit((Formula.UnaryTemporalOperator)gOperator);
    }

    @Override
    public String visit(Literal literal) {
        String name = this.alphabet.get(literal.getAtom());
        return literal.isNegated() ? "\\overline{" + name + "}" : name;
    }

    @Override
    public String visit(MOperator mOperator) {
        return this.visit((Formula.BinaryTemporalOperator)mOperator);
    }

    @Override
    public String visit(ROperator rOperator) {
        return this.visit((Formula.BinaryTemporalOperator)rOperator);
    }

    @Override
    public String visit(UOperator uOperator) {
        return this.visit((Formula.BinaryTemporalOperator)uOperator);
    }

    @Override
    public String visit(WOperator wOperator) {
        return this.visit((Formula.BinaryTemporalOperator)wOperator);
    }

    @Override
    public String visit(XOperator xOperator) {
        return this.visit((Formula.UnaryTemporalOperator)xOperator);
    }

    private String visit(Formula.UnaryTemporalOperator operator) {
        if (operator.operand() instanceof Formula.UnaryTemporalOperator || operator.operand() instanceof Literal) {
            return "\\" + operator.operatorSymbol() + " " + operator.operand().accept(this);
        }
        return "\\" + operator.operatorSymbol() + " (" + operator.operand().accept(this) + ")";
    }

    private String visit(Formula.BinaryTemporalOperator operator) {
        return Stream.of(operator.leftOperand(), operator.rightOperand()).map(x -> {
            if (x instanceof Literal) {
                return x.accept(this);
            }
            return "(" + x.accept(this) + ")";
        }).collect(Collectors.joining(" \\" + operator.operatorSymbol() + " "));
    }

    private String visit(Formula.NaryPropositionalOperator propositionalFormula, String latexString) {
        assert (Comparators.isInStrictOrder((Iterable)propositionalFormula.operands, Comparator.naturalOrder()));
        return propositionalFormula.operands.stream().map(x -> {
            if (x instanceof Formula.NaryPropositionalOperator || x instanceof Biconditional) {
                return "(" + x.accept(this) + ")";
            }
            return x.accept(this);
        }).collect(Collectors.joining(latexString));
    }
}

