/*
 * Decompiled with CFR 0.152.
 */
package owl.translations.delag;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import java.util.HashMap;
import java.util.Map;
import owl.ltl.EquivalenceClass;
import owl.ltl.Formula;
import owl.translations.delag.AutoValue_ProductState;
import owl.translations.delag.DependencyTree;

@AutoValue
public abstract class ProductState<T> {
    public abstract Map<Formula, T> fallback();

    public abstract Map<DependencyTree<T>, Boolean> finished();

    public abstract Map<Formula, EquivalenceClass> safety();

    static <T> Builder<T> builder() {
        return new Builder();
    }

    public abstract boolean equals(Object var1);

    @Memoized
    public abstract int hashCode();

    static final class Builder<T> {
        private final Map<Formula, T> fallback = new HashMap<Formula, T>();
        private final Map<DependencyTree<T>, Boolean> finished = new HashMap<DependencyTree<T>, Boolean>();
        private final Map<Formula, EquivalenceClass> safety = new HashMap<Formula, EquivalenceClass>();

        Builder() {
        }

        ProductState<T> build() {
            return new AutoValue_ProductState<T>(Map.copyOf(this.fallback), Map.copyOf(this.finished), Map.copyOf(this.safety));
        }

        void merge(Builder<T> other) {
            other.fallback.forEach(this::addFallback);
            other.finished.forEach(this::addFinished);
            other.safety.forEach(this::addSafety);
        }

        private static <K, V> void add(Map<K, V> map, K key, V value) {
            V oldValue = map.put(key, value);
            assert (oldValue == null || value.equals(oldValue));
        }

        void addFallback(Formula key, T value) {
            Builder.add(this.fallback, key, value);
        }

        void addSafety(Formula key, EquivalenceClass value) {
            Builder.add(this.safety, key, value);
        }

        void addFinished(DependencyTree<T> tree, Boolean value) {
            Builder.add(this.finished, tree, value);
        }
    }
}

